/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.alm.ws.client.internal.connection;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NetworkUtils;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class CommonsHTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((String)CommonsHTTPSender.class.getName());
    protected transient HttpClientConnectionManager connectionManager;
    protected transient CommonsHTTPClientProperties clientProperties;
    private boolean httpChunkStream = false;
    private transient RequestConfig requestConfig;
    public static boolean enableSessionMaintenance = false;
    public static Header[] headersViewable = null;

    public CommonsHTTPSender() {
        this.initialize();
    }

    protected void initialize() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        this.clientProperties = CommonsHTTPClientPropertiesFactory.create();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        cm.setDefaultMaxPerRoute(this.clientProperties.getMaximumConnectionsPerHost());
        cm.setMaxTotal(this.clientProperties.getMaximumTotalConnections());
        if (this.clientProperties.getDefaultConnectionTimeout() > 0) {
            requestConfigBuilder.setConnectTimeout(this.clientProperties.getDefaultConnectionTimeout());
        }
        if (this.clientProperties.getDefaultSoTimeout() > 0) {
            requestConfigBuilder.setSocketTimeout(this.clientProperties.getDefaultSoTimeout());
        }
        cm.setValidateAfterInactivity(300);
        this.requestConfig = requestConfigBuilder.build();
        this.connectionManager = cm;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        HttpGet method = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"enter00", (String)"CommonsHTTPSender::invoke"));
        }
        try {
            String webMethod;
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            RequestConfig.Builder rcBuilderForHttpClient = RequestConfig.copy((RequestConfig)this.requestConfig).setConnectionRequestTimeout(this.clientProperties.getConnectionPoolTimeout());
            HttpClientContext httpClientContext = HttpClientContext.create();
            HttpRoute httpRoute = this.getHttpRoute(httpClientContext, targetURL);
            boolean posting = true;
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
                posting = webMethod.equals("POST");
            }
            RequestConfig.Builder rcBuilderForMethod = RequestConfig.copy((RequestConfig)this.requestConfig);
            if (posting) {
                Message reqMessage = msgContext.getRequestMessage();
                method = new HttpPost(targetURL.toString());
                rcBuilderForMethod.setExpectContinueEnabled(false);
                this.addContextInfo((HttpRequestBase)method, rcBuilderForMethod, httpClientContext, msgContext, targetURL);
                MessageRequestEntity requestEntity = null;
                requestEntity = msgContext.isPropertyTrue("transport.http.gzipRequest") ? new GzipMessageRequestEntity((HttpRequestBase)method, reqMessage, this.httpChunkStream) : new MessageRequestEntity((HttpRequestBase)method, reqMessage, this.httpChunkStream);
                ((HttpPost)method).setEntity((HttpEntity)requestEntity);
            } else {
                method = new HttpGet(targetURL.toString());
                this.addContextInfo((HttpRequestBase)method, rcBuilderForMethod, httpClientContext, msgContext, targetURL);
            }
            String httpVersion = msgContext.getStrProp("axis.transport.version");
            if (httpVersion != null && httpVersion.equals(HTTPConstants.HEADER_PROTOCOL_V10)) {
                method.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
            }
            if (enableSessionMaintenance || msgContext.getMaintainSession()) {
                BasicCookieStore cookieStore = new BasicCookieStore();
                rcBuilderForMethod.setCookieSpec("default");
                String host = httpRoute.getTargetHost().getHostName();
                String path = targetURL.getPath();
                boolean secure = httpRoute.isSecure();
                this.fillHeaders(msgContext, (CookieStore)cookieStore, "Cookie", host, path, secure);
                this.fillHeaders(msgContext, (CookieStore)cookieStore, "Cookie2", host, path, secure);
                httpClientContext.setCookieStore((CookieStore)cookieStore);
            }
            method.setConfig(rcBuilderForMethod.build());
            Throwable throwable = null;
            Object var11_13 = null;
            try (CloseableHttpClient httpClient = this.getCloseableHttpClient(rcBuilderForHttpClient, httpRoute);){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)method, (HttpContext)httpClientContext);
                int returnCode = response.getStatusLine().getStatusCode();
                String contentType = CommonsHTTPSender.getHeader((HttpResponse)response, "Content-Type");
                String contentLocation = CommonsHTTPSender.getHeader((HttpResponse)response, "Content-Location");
                String contentLength = CommonsHTTPSender.getHeader((HttpResponse)response, "Content-Length");
                if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                    String statusMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                    AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                    try {
                        fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + returnCode), (String)EntityUtils.toString((HttpEntity)response.getEntity())));
                        fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(returnCode));
                        throw fault;
                    }
                    catch (Throwable throwable2) {
                        method.releaseConnection();
                        throw throwable2;
                    }
                }
                InputStream releaseConnectionOnCloseStream = this.createConnectionReleasingInputStream((HttpRequestBase)method, (HttpResponse)response);
                Header contentEncoding = response.getFirstHeader("Content-Encoding");
                if (contentEncoding != null) {
                    if (contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                        releaseConnectionOnCloseStream = new GZIPInputStream(releaseConnectionOnCloseStream);
                    } else {
                        AxisFault fault = new AxisFault("HTTP", "unsupported content-encoding of '" + contentEncoding.getValue() + "' found", null, null);
                        throw fault;
                    }
                }
                Message outMsg = new Message((Object)releaseConnectionOnCloseStream, false, contentType, contentLocation);
                Header[] responseHeaders = response.getAllHeaders();
                MimeHeaders responseMimeHeaders = outMsg.getMimeHeaders();
                Header[] headerArray = responseHeaders;
                int n = responseHeaders.length;
                int n2 = 0;
                while (n2 < n) {
                    Header responseHeader = headerArray[n2];
                    responseMimeHeaders.addHeader(responseHeader.getName(), responseHeader.getValue());
                    ++n2;
                }
                outMsg.setMessageType("response");
                msgContext.setResponseMessage(outMsg);
                if (log.isDebugEnabled()) {
                    if (contentLength == null) {
                        log.debug((Object)("\n" + Messages.getMessage((String)"no00", (String)"Content-Length")));
                    }
                    log.debug((Object)("\n" + Messages.getMessage((String)"xmlRecd00")));
                    log.debug((Object)"-----------------------------------------------");
                    log.debug((Object)outMsg.getSOAPPartAsString());
                }
                if (enableSessionMaintenance || msgContext.getMaintainSession()) {
                    Header[] headers = response.getAllHeaders();
                    headersViewable = headers;
                    Header[] headerArray2 = headers;
                    int n3 = headers.length;
                    n = 0;
                    while (n < n3) {
                        Header header = headerArray2[n];
                        if (header.getName().equalsIgnoreCase("Set-Cookie")) {
                            this.handleCookie("Cookie", header.getValue(), msgContext);
                        } else if (header.getName().equalsIgnoreCase("Set-Cookie2")) {
                            this.handleCookie("Cookie2", header.getValue(), msgContext);
                        }
                        ++n;
                    }
                }
                if (msgContext.isPropertyTrue("axis.one.way")) {
                    method.releaseConnection();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault((Exception)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"exit00", (String)"CommonsHTTPSender::invoke"));
        }
    }

    private CloseableHttpClient getCloseableHttpClient(RequestConfig.Builder rcBuilderForHttpClient, HttpRoute httpRoute) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this.connectionManager).setConnectionManagerShared(true).setDefaultRequestConfig(rcBuilderForHttpClient.build()).setRetryHandler((HttpRequestRetryHandler)new RetryHandler());
        if (httpRoute.getProxyHost() != null) {
            httpClientBuilder = httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(httpRoute.getProxyHost()));
        }
        return httpClientBuilder.build();
    }

    public void handleCookie(String cookieName, String cookie, MessageContext msgContext) {
        int keyIndex = cookie.indexOf("=");
        String key = keyIndex != -1 ? cookie.substring(0, keyIndex) : cookie;
        ArrayList<String> cookies = new ArrayList<String>();
        Object oldCookies = msgContext.getProperty(cookieName);
        boolean alreadyExist = false;
        if (oldCookies != null) {
            if (oldCookies instanceof String[]) {
                String[] oldCookiesArray;
                String[] stringArray = oldCookiesArray = (String[])oldCookies;
                int n = oldCookiesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String element;
                    String anOldCookie = element = stringArray[n2];
                    if (key != null && anOldCookie.indexOf(key) == 0) {
                        anOldCookie = cookie;
                        alreadyExist = true;
                    }
                    cookies.add(anOldCookie);
                    ++n2;
                }
            } else {
                String oldCookie = (String)oldCookies;
                if (key != null && oldCookie.indexOf(key) == 0) {
                    oldCookie = cookie;
                    alreadyExist = true;
                }
                cookies.add(oldCookie);
            }
        }
        if (!alreadyExist) {
            cookies.add(cookie);
        }
        if (cookies.size() == 1) {
            msgContext.setProperty(cookieName, cookies.get(0));
        } else if (cookies.size() > 1) {
            msgContext.setProperty(cookieName, (Object)cookies.toArray(new String[cookies.size()]));
        }
    }

    private void fillHeaders(MessageContext msgContext, CookieStore cookieStore, String header, String host, String path, boolean secure) {
        Object ck1 = msgContext.getProperty(header);
        if (ck1 != null) {
            if (ck1 instanceof String[]) {
                String[] cookies;
                String[] stringArray = cookies = (String[])ck1;
                int n = cookies.length;
                int n2 = 0;
                while (n2 < n) {
                    String cookie = stringArray[n2];
                    this.addCookie(cookieStore, cookie, host, path, secure);
                    ++n2;
                }
            } else {
                this.addCookie(cookieStore, (String)ck1, host, path, secure);
            }
        }
    }

    private void addCookie(CookieStore cookieStore, String cookie, String host, String path, boolean secure) {
        int index = cookie.indexOf(61);
        BasicClientCookie basicClientCookie = new BasicClientCookie(cookie.substring(0, index), cookie.substring(index + 1));
        basicClientCookie.setPath(path);
        basicClientCookie.setDomain(host);
        basicClientCookie.setSecure(secure);
        cookieStore.addCookie((Cookie)basicClientCookie);
    }

    private String cleanupCookie(String cookie) {
        int index = (cookie = cookie.trim()).indexOf(59);
        if (index != -1) {
            cookie = cookie.substring(0, index);
        }
        return cookie;
    }

    private HttpRoute getHttpRoute(HttpClientContext httpClientContext, URL targetURL) throws AxisFault {
        TransportClientProperties tcp = TransportClientPropertiesFactory.create((String)targetURL.getProtocol());
        if (tcp == null) {
            throw new AxisFault("Unsupported protocol: " + targetURL.getProtocol());
        }
        int port = targetURL.getPort();
        boolean hostInNonProxyList = this.isHostInNonProxyList(targetURL.getHost(), tcp.getNonProxyHosts());
        if (port == -1) {
            port = targetURL.getProtocol().equalsIgnoreCase("https") ? 443 : 80;
        }
        HttpHost host = new HttpHost(targetURL.getHost(), port, targetURL.getProtocol());
        if (hostInNonProxyList) {
            return new HttpRoute(host);
        }
        if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0) {
            return new HttpRoute(host);
        }
        this.configureProxyCredentials(httpClientContext, tcp);
        int proxyPort = Integer.parseInt(tcp.getProxyPort());
        HttpHost proxy = new HttpHost(tcp.getProxyHost(), proxyPort);
        return new HttpRoute(host, proxy);
    }

    private void configureProxyCredentials(HttpClientContext httpClientContext, TransportClientProperties tcp) {
        if (tcp.getProxyUser().length() != 0) {
            UsernamePasswordCredentials proxyCred = new UsernamePasswordCredentials(tcp.getProxyUser(), tcp.getProxyPassword());
            int domainIndex = tcp.getProxyUser().indexOf("\\");
            if (domainIndex > 0) {
                String domain = tcp.getProxyUser().substring(0, domainIndex);
                if (tcp.getProxyUser().length() > domainIndex + 1) {
                    String user = tcp.getProxyUser().substring(domainIndex + 1);
                    proxyCred = new NTCredentials(user, tcp.getProxyPassword(), tcp.getProxyHost(), domain);
                }
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)proxyCred);
            httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    private void addContextInfo(HttpRequestBase method, RequestConfig.Builder rcBuilderForMethod, HttpClientContext context, MessageContext msgContext, URL tmpURL) throws Exception {
        Hashtable userHeaderTable;
        MimeHeaders mimeHeaders;
        Message msg;
        String action;
        if (msgContext.getTimeout() != 0) {
            rcBuilderForMethod.setSocketTimeout(msgContext.getTimeout()).setConnectTimeout(msgContext.getTimeout());
        }
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if ((msg = msgContext.getRequestMessage()) != null) {
            method.setHeader((Header)new BasicHeader("Content-Type", msg.getContentType(msgContext.getSOAPConstants())));
        }
        method.setHeader((Header)new BasicHeader("SOAPAction", "\"" + action + "\""));
        method.setHeader((Header)new BasicHeader("User-Agent", Messages.getMessage((String)"axisUserAgent")));
        String userID = msgContext.getUsername();
        String passwd = msgContext.getPassword();
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            UsernamePasswordCredentials proxyCred = new UsernamePasswordCredentials(userID, passwd);
            int domainIndex = userID.indexOf("\\");
            if (domainIndex > 0) {
                String domain = userID.substring(0, domainIndex);
                if (userID.length() > domainIndex + 1) {
                    String user = userID.substring(domainIndex + 1);
                    proxyCred = new NTCredentials(user, passwd, NetworkUtils.getLocalHostname(), domain);
                }
            }
            BasicCredentialsProvider credentialsPovider = new BasicCredentialsProvider();
            credentialsPovider.setCredentials(AuthScope.ANY, (Credentials)proxyCred);
            context.setCredentialsProvider((CredentialsProvider)credentialsPovider);
        }
        if (msgContext.isPropertyTrue("transport.http.acceptGzip")) {
            method.addHeader("Accept-Encoding", "gzip");
        }
        if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
            method.addHeader("Content-Encoding", "gzip");
        }
        MimeHeaders mimeHeaders2 = mimeHeaders = msg != null ? msg.getMimeHeaders() : null;
        if (mimeHeaders != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                String headerName = mimeHeader.getName();
                if (headerName.equals("Content-Type") || headerName.equals("SOAPAction")) continue;
                method.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            for (Map.Entry element : userHeaderTable.entrySet()) {
                Map.Entry me = element;
                Object keyObj = me.getKey();
                if (keyObj == null) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                if (key.equalsIgnoreCase("Expect") && value.equalsIgnoreCase("100-continue")) {
                    rcBuilderForMethod.setExpectContinueEnabled(true);
                    continue;
                }
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                    String val = me.getValue().toString();
                    if (val == null) continue;
                    this.httpChunkStream = JavaUtils.isTrue((String)val);
                    continue;
                }
                method.addHeader(key, value);
            }
        }
    }

    protected boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"match00", (String[])new String[]{"HTTPSender", host, pattern}));
            }
            if (!CommonsHTTPSender.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        var14_10 = patArr;
        var13_12 = patArr.length;
        var12_13 = 0;
        while (var12_13 < var13_12) {
            element = var14_10[var12_13];
            if (element == '*') {
                containsStar = true;
                break;
            }
            ++var12_13;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (isCaseSensitive && ch != strArr[i]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl39
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl39:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl40:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl54
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl54:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl55:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl95
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block27: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (!(isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl95:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl96:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getHeader(HttpResponse response, String headerName) {
        Header header = response.getFirstHeader(headerName);
        return header == null ? null : header.getValue().trim();
    }

    private InputStream createConnectionReleasingInputStream(final HttpRequestBase method, HttpResponse response) throws IOException {
        return new FilterInputStream(response.getEntity().getContent()){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    method.releaseConnection();
                }
            }
        };
    }

    private static class GzipMessageRequestEntity
    extends MessageRequestEntity {
        private ByteArrayOutputStream cachedStream;

        public GzipMessageRequestEntity(HttpRequestBase method, Message message) {
            super(method, message);
        }

        public GzipMessageRequestEntity(HttpRequestBase method, Message message, boolean httpChunkStream) {
            super(method, message, httpChunkStream);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            if (this.cachedStream != null) {
                this.cachedStream.writeTo(out);
            } else {
                GZIPOutputStream gzStream = new GZIPOutputStream(out);
                super.writeTo(gzStream);
                gzStream.finish();
            }
        }

        @Override
        public long getContentLength() {
            if (this.isContentLengthNeeded()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.writeTo(baos);
                    this.cachedStream = baos;
                    return baos.size();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return -1L;
        }
    }

    private static class MessageRequestEntity
    implements HttpEntity {
        private HttpRequestBase method;
        private Message message;
        boolean httpChunkStream = true;

        public MessageRequestEntity(HttpRequestBase method, Message message) {
            this.message = message;
            this.method = method;
        }

        public MessageRequestEntity(HttpRequestBase method, Message message, boolean httpChunkStream) {
            this.message = message;
            this.method = method;
            this.httpChunkStream = httpChunkStream;
        }

        public boolean isRepeatable() {
            return true;
        }

        public void writeTo(OutputStream out) throws IOException {
            try {
                this.message.writeTo(out);
            }
            catch (SOAPException e) {
                throw new IOException(e.getMessage());
            }
        }

        protected boolean isContentLengthNeeded() {
            return this.method.getProtocolVersion() == HttpVersion.HTTP_1_0 || !this.httpChunkStream;
        }

        public long getContentLength() {
            if (this.isContentLengthNeeded()) {
                try {
                    return this.message.getContentLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1L;
        }

        public Header getContentType() {
            return null;
        }

        public void consumeContent() throws IOException {
        }

        public InputStream getContent() throws IOException, UnsupportedOperationException {
            return null;
        }

        public Header getContentEncoding() {
            return this.method.getFirstHeader("Content-Encoding");
        }

        public boolean isChunked() {
            return this.httpChunkStream;
        }

        public boolean isStreaming() {
            return false;
        }
    }

    private static final class RetryHandler
    extends DefaultHttpRequestRetryHandler {
        private RetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (super.retryRequest(exception, executionCount, context)) {
                return true;
            }
            if (executionCount > this.getRetryCount()) {
                return false;
            }
            return exception instanceof SocketException;
        }
    }
}

