/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.alm.ws.client;

import com.polarion.alm.ws.client.builder.BuilderWebService;
import com.polarion.alm.ws.client.builder.BuilderWebServiceServiceLocator;
import com.polarion.alm.ws.client.internal.ClientSessionHandlerInfo;
import com.polarion.alm.ws.client.planning.PlanningWebService;
import com.polarion.alm.ws.client.planning.PlanningWebServiceServiceLocator;
import com.polarion.alm.ws.client.projects.ProjectWebService;
import com.polarion.alm.ws.client.projects.ProjectWebServiceServiceLocator;
import com.polarion.alm.ws.client.security.SecurityWebService;
import com.polarion.alm.ws.client.security.SecurityWebServiceServiceLocator;
import com.polarion.alm.ws.client.session.SessionWebService;
import com.polarion.alm.ws.client.session.SessionWebServiceServiceLocator;
import com.polarion.alm.ws.client.testmanagement.TestManagementWebService;
import com.polarion.alm.ws.client.testmanagement.TestManagementWebServiceServiceLocator;
import com.polarion.alm.ws.client.tracker.TrackerWebService;
import com.polarion.alm.ws.client.tracker.TrackerWebServiceServiceLocator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;

public class WebServiceFactory {
    private static final String TRACKER_SERVICE_NAME = "TrackerWebService";
    private static final String PROJECT_SERVICE_NAME = "ProjectWebService";
    private static final String SESSION_SERVICE_NAME = "SessionWebService";
    private static final String SECURITY_SERVICE_NAME = "SecurityWebService";
    private static final String BUILDER_SERVICE_NAME = "BuilderWebService";
    private static final String TESTMANAGEMENT_SERVICE_NAME = "TestManagementWebService";
    private static final String PLANNING_SERVICE_NAME = "PlanningWebService";
    private URL trackerServiceURL;
    private URL projectServiceURL;
    private URL sessionServiceURL;
    private URL securityServiceURL;
    private URL builderServiceURL;
    private URL testManagementServiceURL;
    private URL planningServiceURL;
    private HandlerInfo sessionHandler = new ClientSessionHandlerInfo();
    private TrackerWebServiceServiceLocator trackerWebServiceServiceLocator;
    private ProjectWebServiceServiceLocator projectWebServiceServiceLocator;
    private SessionWebServiceServiceLocator sessionWebServiceServiceLocator;
    private SecurityWebServiceServiceLocator securityWebServiceServiceLocator;
    private BuilderWebServiceServiceLocator builderWebServiceServiceLocator;
    private TestManagementWebServiceServiceLocator testManagementServiceLocator;
    private PlanningWebServiceServiceLocator planningServiceLocator;

    public WebServiceFactory(String baseURL) throws MalformedURLException {
        this.trackerServiceURL = new URL(String.valueOf(baseURL) + TRACKER_SERVICE_NAME);
        this.projectServiceURL = new URL(String.valueOf(baseURL) + PROJECT_SERVICE_NAME);
        this.sessionServiceURL = new URL(String.valueOf(baseURL) + SESSION_SERVICE_NAME);
        this.securityServiceURL = new URL(String.valueOf(baseURL) + SECURITY_SERVICE_NAME);
        this.builderServiceURL = new URL(String.valueOf(baseURL) + BUILDER_SERVICE_NAME);
        this.testManagementServiceURL = new URL(String.valueOf(baseURL) + TESTMANAGEMENT_SERVICE_NAME);
        this.planningServiceURL = new URL(String.valueOf(baseURL) + PLANNING_SERVICE_NAME);
        this.trackerWebServiceServiceLocator = new TrackerWebServiceServiceLocator();
        this.trackerWebServiceServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.trackerWebServiceServiceLocator);
        this.projectWebServiceServiceLocator = new ProjectWebServiceServiceLocator();
        this.projectWebServiceServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.projectWebServiceServiceLocator);
        this.sessionWebServiceServiceLocator = new SessionWebServiceServiceLocator();
        this.sessionWebServiceServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.sessionWebServiceServiceLocator);
        this.securityWebServiceServiceLocator = new SecurityWebServiceServiceLocator();
        this.securityWebServiceServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.securityWebServiceServiceLocator);
        this.builderWebServiceServiceLocator = new BuilderWebServiceServiceLocator();
        this.builderWebServiceServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.builderWebServiceServiceLocator);
        this.testManagementServiceLocator = new TestManagementWebServiceServiceLocator();
        this.testManagementServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.testManagementServiceLocator);
        this.planningServiceLocator = new PlanningWebServiceServiceLocator();
        this.planningServiceLocator.setMaintainSession(true);
        this.addSessionHandler(this.planningServiceLocator);
    }

    public TrackerWebService getTrackerService() throws ServiceException {
        return this.trackerWebServiceServiceLocator.getTrackerWebService(this.trackerServiceURL);
    }

    public ProjectWebService getProjectService() throws ServiceException {
        return this.projectWebServiceServiceLocator.getProjectWebService(this.projectServiceURL);
    }

    public SessionWebService getSessionService() throws ServiceException {
        return this.sessionWebServiceServiceLocator.getSessionWebService(this.sessionServiceURL);
    }

    public SecurityWebService getSecurityService() throws ServiceException {
        return this.securityWebServiceServiceLocator.getSecurityWebService(this.securityServiceURL);
    }

    public BuilderWebService getBuilderService() throws ServiceException {
        return this.builderWebServiceServiceLocator.getBuilderWebService(this.builderServiceURL);
    }

    public TestManagementWebService getTestManagementService() throws ServiceException {
        return this.testManagementServiceLocator.getTestManagementWebService(this.testManagementServiceURL);
    }

    public PlanningWebService getPlanningService() throws ServiceException {
        return this.planningServiceLocator.getPlanningWebService(this.planningServiceURL);
    }

    private void addSessionHandler(Service service) {
        HandlerRegistry hr = service.getHandlerRegistry();
        try {
            Iterator i = service.getPorts();
            while (i.hasNext()) {
                List chain = hr.getHandlerChain((QName)i.next());
                chain.add(this.sessionHandler);
            }
        }
        catch (ServiceException e) {
            throw new AssertionError((Object)("Unexpected initialization error: " + (Object)((Object)e)));
        }
    }
}

