package com.polarion.alm.ws.client.internal;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;

import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.HTTPConstants;

public class ClientSessionHandler implements Handler {

    private static final String SESSION_NS = "http://ws.polarion.com/session";

    private static final String SESSION_LOCALPART = "sessionID";

    private ClientSessionHandlerInfo info;

    @Override
    public void destroy() {
        // TODO Auto-generated method stub
    }

    @Override
    public QName[] getHeaders() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean handleFault(javax.xml.rpc.handler.MessageContext arg0) {
        return false;
    }

    @Override
    public boolean handleRequest(javax.xml.rpc.handler.MessageContext arg0) {
        Long currentClientSession = info.getSessionId();
        if (currentClientSession == null) {
            return true;
        }
        // We have a session ID, so insert the header
        Message msg = ((MessageContext) arg0).getRequestMessage();
        if (msg == null) {
            return false;
        }

        SOAPEnvelope env;
        try {
            env = msg.getSOAPEnvelope();
            SOAPHeaderElement header = new SOAPHeaderElement(SESSION_NS,
                    SESSION_LOCALPART, currentClientSession);
            env.addHeader(header);
            if (info.getSessionCookie() != null && !info.getSessionCookie().isEmpty()) {
                arg0.setProperty(HTTPConstants.HEADER_COOKIE, info.getSessionCookie());
            }
        } catch (AxisFault e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    @Override
    public boolean handleResponse(javax.xml.rpc.handler.MessageContext arg0) {
        Message msg = ((MessageContext) arg0).getResponseMessage();
        if (msg == null) {
            return false;
        }
        SOAPEnvelope env;
        try {
            env = msg.getSOAPEnvelope();
            SOAPHeaderElement header = env.getHeaderByName(SESSION_NS,
                    SESSION_LOCALPART);
            if (header == null) {
                return false;
            }

            info.setSessionId((Long) header.getValueAsType(Constants.XSD_LONG));
            header.setProcessed(true);
            if (arg0.getProperty(HTTPConstants.HEADER_COOKIE) != null) {
                info.setSessionCookie((String) arg0.getProperty(HTTPConstants.HEADER_COOKIE));
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    @Override
    public void init(HandlerInfo arg0) {
        info = (ClientSessionHandlerInfo) arg0;
    }

}
