/**
 * TrackerWebService.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.polarion.alm.ws.client.tracker;

public interface TrackerWebService extends java.rmi.Remote {

    /**
     * Adds an approvee.
     * @param workitemURI The URI of the Work Item to add an approvee to.
     * @param approveeId The Id of the user to add as an approvee.
     */
    public void addApprovee(java.lang.String workitemURI, java.lang.String approveeId) throws java.rmi.RemoteException;

    /**
     * Adds an assignee.
     * @param workitemURI The URI of the Work Item to add the assignee to.
     * @param assigneeId the Id of the user to add as an assignee.
     */
    public boolean addAssignee(java.lang.String workitemURI, java.lang.String assigneeId) throws java.rmi.RemoteException;

    /**
     * Adds a Category to a Work Item.
     * @param workitemURI The URI of the Work Item to add the Category to.
     * @param categoryId The Id of the Category to add.
     */
    public boolean addCategory(java.lang.String workitemURI, java.lang.String categoryId) throws java.rmi.RemoteException;

    /**
     * Adds a comment to a Work Item, Document, Test Run or as a reply
     * to an existing comment.
     * @param parentObjectUri The URI of the parent object (not null).
     * @param title The title of the new comment or {@code null}.
     * @param content The content of the new comment or {@code null}.
     * @throws java.rmi.RemoteException if the title is not null in a Document
     * or reply comment, or
     * if the parent URI is of an object that does not support comments.
     * @since 3.10.2
     */
    public java.lang.String addComment(java.lang.String parentObjectUri, java.lang.String title, com.polarion.alm.ws.client.types.Text content) throws java.rmi.RemoteException;

    /**
     * Adds a comment to the Activity.
     * @param activityGlobalId The Activity's global Id (not null).
     * @param commentText The comment's text (not null).
     * @since 3.7.0
     */
    public void addCommentToActivity(java.lang.String activityGlobalId, com.polarion.alm.ws.client.types.Text commentText) throws java.rmi.RemoteException;

    /**
     * Links a revision from an external repository.
     * @param workitemURI The URI of the Work Item to add the revision to.
     * @param repositoryName The Id of the external repository.
     * @param revisionId The Id of the revision to add.
     * @since 3.5.1
     */
    public boolean addExternalLinkedRevision(java.lang.String workitemURI, java.lang.String repositoryName, java.lang.String revisionId) throws java.rmi.RemoteException;

    /**
     * Adds an external linked Work Item.
     * @param workitemURI The URI of the Work Item to add the link to.
     * @param linkedExternalWorkitemURI The URI of the target external Work
     * Item the link points to.
     * @param role The role of the link to add.
     * @since 3.5.0
     */
    public boolean addExternallyLinkedItem(java.lang.String workitemURI, java.lang.String linkedExternalWorkitemURI, com.polarion.alm.ws.client.types.tracker.EnumOptionId role) throws java.rmi.RemoteException;

    /**
     * Adds a hyperlink.
     * @param workitemURI The URI of the Work Item to add the hyperlink to.
     * @param url The url of the hyperlink to add.
     * @param role The role of the hyperlink to add.
     */
    public boolean addHyperlink(java.lang.String workitemURI, java.lang.String url, com.polarion.alm.ws.client.types.tracker.EnumOptionId role) throws java.rmi.RemoteException;

    /**
     * Adds a linked Work Item.
     * @param workitemURI The URI of the Work Item to add the link to.
     * @param linkedWorkitemURI The URI of the target Work Item the link
     * points to.
     * @param role The role of the link to add.
     */
    public boolean addLinkedItem(java.lang.String workitemURI, java.lang.String linkedWorkitemURI, com.polarion.alm.ws.client.types.tracker.EnumOptionId role) throws java.rmi.RemoteException;

    /**
     * Adds a linked item to the specific Work Item with a revision.
     * @param in0 workitemURI The URI of the Work Item to add the link to.
     * @param in1 linkedWorkitemURI The URI of the target Work Item the link
     * points to.
     * @param in2 role The role of the linked item to add.
     * @param in3 revision specific The revision for a linked item (null
     * refers to the HEAD revision).
     * @param in4 suspect true if the link should be marked with a suspect
     * flag.
     * @since 3.4.3
     */
    public boolean addLinkedItemWithRev(java.lang.String in0, java.lang.String in1, com.polarion.alm.ws.client.types.tracker.EnumOptionId in2, java.lang.String in3, boolean in4) throws java.rmi.RemoteException;

    /**
     * Adds an OSLC item.
     * @param workitemURI The URI of the Work Item to add the link to.
     * @param linkedOslcItemURI The URI of the target resource the link points
     * to.
     * @param role The role of the link to add.
     * @param label The label of the link to add.
     * @since 3.10.2
     */
    public boolean addLinkedOslcItem(java.lang.String workitemURI, java.lang.String linkedOslcItemURI, com.polarion.alm.ws.client.types.tracker.EnumOptionId role, java.lang.String label) throws java.rmi.RemoteException;

    /**
     * Links a revision.
     * @param workitemURI The URI of the Work Item to add the revision to.
     * @param revisionId The Id of the revision to add.
     */
    public boolean addLinkedRevision(java.lang.String workitemURI, java.lang.String revisionId) throws java.rmi.RemoteException;

    /**
     * Adds a planing constraint.
     * @param workitemURI The URI of the Work Item to add the planning constraint
     * to.
     * @param date The date of the planning constraint to add.
     * @param constraint The type of constraint to add.
     */
    public boolean addPlaningContraint(java.lang.String workitemURI, java.util.Calendar date, com.polarion.alm.ws.client.types.tracker.EnumOptionId constraint) throws java.rmi.RemoteException;

    /**
     * Returns true if the Activity allows for comments.
     * @param activityGlobalId The Activity's global Id (not null).
     * @return true if Activity allows for comments. Otherwise false.
     * @since 3.7.0
     */
    public boolean canCommentActivity(java.lang.String activityGlobalId) throws java.rmi.RemoteException;

    /**
     * Returns true if the current User can comment on the Activity.
     * @param activityGlobalId The Activity's global Id (not null).
     * @return true if the current user can comment on the Activity. Otherwise
     * false.
     * @since 3.7.0
     */
    public boolean canCurrentUserAddCommentToActivity(java.lang.String activityGlobalId) throws java.rmi.RemoteException;

    /**
     * Creates a new attachment.
     * @param workitemURI The URI of the Work Item to add the attachment
     * to.
     * @param fileName The fileName of the attachment.
     * @param title The title of the attachment.
     * @param data The content of the attachment.
     * @since 3.3.1
     */
    public void createAttachment(java.lang.String workitemURI, java.lang.String fileName, java.lang.String title, byte[] data) throws java.rmi.RemoteException;

    /**
     * Creates a Baseline from the head or particular revision.
     * @param projectId The Project Id (not null).
     * @param name the Baseline's name (not null).
     * @param description The Baseline's description (can be null).
     * @param revision The revision or a null value for the Head revision.
     * @return The Created Baseline.
     * @since 3.7.1
     */
    public com.polarion.alm.ws.client.types.tracker.Baseline createBaseline(java.lang.String projectId, java.lang.String name, java.lang.String description, java.lang.String revision) throws java.rmi.RemoteException;

    /**
     * Creates a comment.
     * @param workitemURI The URI of the Work Item to create a comment for.
     * @param content The content of the comment to create.
     * @deprecated Use {@link #addComment(String, String, com.polarion.alm.ws.client.types.Text)}.
     */
    public void createComment(java.lang.String workitemURI, com.polarion.alm.ws.client.types.Text content) throws java.rmi.RemoteException;

    /**
     * Creates a comment.
     * @param parentURI The URI of the parent item (either a Work Item or
     * another comment) to create the comment for.
     * @param title The title of the comment.
     * @param content The content of the comment to create.
     * @param visibleTo Who this comment should be visible to.
     * @since 3.1.2
     * @deprecated Use {@link #addComment(String, String, com.polarion.alm.ws.client.types.Text)}.
     */
    public java.lang.String createCommentNew(java.lang.String parentURI, java.lang.String title, com.polarion.alm.ws.client.types.Text content, java.lang.String[] visibleTo) throws java.rmi.RemoteException;

    /**
     * Creates a Document in the given location with the given parameters.
     * @param projectId The Project Id (not null)
     * @param location The document's Space location with one component or
     * null for the default space. (Can be null.)
     * @param documentName The Document's name (not null).
     * @param documentTitle The Document's title (can be null).
     * @param allowedWITypes A single Type can be specified. (Can be null.)
     * @param structureLinkRole The role that defines the hierarchy of the
     * Work Items inside the Document. (Not null.)
     * @param homePageContent The HTML markup for a document home page. (Can
     * be null).
     * @return The URI of the created Document.
     * @since 3.8.2
     */
    public java.lang.String createDocument(java.lang.String projectId, java.lang.String location, java.lang.String documentName, java.lang.String documentTitle, com.polarion.alm.ws.client.types.tracker.EnumOptionId[] allowedWITypes, com.polarion.alm.ws.client.types.tracker.EnumOptionId structureLinkRole, java.lang.String homePageContent) throws java.rmi.RemoteException;

    /**
     * Creates an unreferenced comment in the Document.
     * @param documentURI The Document SubterraURI.
     * @param text The comment's text.
     * @return The SubterraURI of the newly created comment
     * @since 3.7.0
     * @deprecated Use {@link #addComment(String, String, com.polarion.alm.ws.client.types.Text)}.
     */
    public java.lang.String createDocumentComment(java.lang.String documentURI, com.polarion.alm.ws.client.types.Text text) throws java.rmi.RemoteException;

    /**
     * Creates a comment referring to a Work Item in the Document.
     * @param documentURI The document SubterraURI.
     * @param workItemURI The Work Item SubterraURI.
     * @param text The comment's text.  
     * @return The SubterraURI of the newly created comment.
     * @since 3.7.0
     */
    public java.lang.String createDocumentCommentReferringWI(java.lang.String documentURI, java.lang.String workItemURI, com.polarion.alm.ws.client.types.Text text) throws java.rmi.RemoteException;

    /**
     * Creates a comment as a reply to a given parent Comment in the
     * Document.
     * @param parentURI The parent comment SubterraURI.
     * @param text The comment's text.
     * @return The SubterraURI of the newly created comment.
     * @since 3.7.0
     * @deprecated Use {@link #addComment(String, String, com.polarion.alm.ws.client.types.Text)}.
     */
    public java.lang.String createDocumentCommentReply(java.lang.String parentURI, com.polarion.alm.ws.client.types.Text text) throws java.rmi.RemoteException;

    /**
     * Creates and returns a sub folder for parentName folder, if
     * it is not {@code null}, otherwise it creates a new folder under the
     * "Documents & Pages" root Topic.
     * @param projectId The project ID or null for the Global level.
     * @param parentName (ID) must be unique for the whole folder hierarchy.
     * @param name (ID) must be unique for the whole folder hierarchy.
     * @param title The title for the folder.
     * @since 3.18.1
     */
    public com.polarion.alm.ws.client.types.tracker.Folder createFolder(java.lang.String projectId, java.lang.String parentName, java.lang.String name, java.lang.String title) throws java.rmi.RemoteException;

    /**
     * Creates a document or an old-style Module/Document in a given
     * location with the given parameters.
     * @param projectId the Project Id.
     * @param location The document Space location with a single component
     * (e.g. "_default" for the default space) or null for old-style Modules.
     * @param moduleName The Document/Module name.
     * @param allowedWITypes The allowed Work Item Types. Only one type can
     * be specified.
     * @param structureLinkRole The required, role that defines the hierarchy
     * of Work Items inside the Module/Document.
     * @param parentToChild Always false.
     * @param homePageContent The HTML markup for a document home page or
     * Wiki markup for the old-style Module home page or null if the default
     * is OK.
     * @return The URI of the created Module/Document.
     * @since 3.4.1
     */
    public java.lang.String createModule(java.lang.String projectId, java.lang.String location, java.lang.String moduleName, com.polarion.alm.ws.client.types.tracker.EnumOptionId[] allowedWITypes, com.polarion.alm.ws.client.types.tracker.EnumOptionId structureLinkRole, boolean parentToChild, java.lang.String homePageContent) throws java.rmi.RemoteException;

    /**
     * Creates a new Work Item with the given content.
     * The Project and the Type must be set or the Work Item will not be
     * created.
     * The URI MUST NOT be set, otherwise the creation will fail.
     * To create a Work Item in a specific location e.g. a LiveDoc, set the
     * location of the Work Item to the desired target location.
     * To create a Work Item in a specific Module/Document, set the Module/Document
     * of the Work Item to the desired target Module/Document.
     * 
     * Please note that some fields in the newly created Work Item will not
     * be changed:
     * assignee, hyperlink, comment, category, created, updated, resolution,
     * linkedWorkItem, linkedWorkItemsDerived, externallyLinkedWorkItems,
     * approvals, workRecords, plannedEnd, plannedStart, plannedInURIs, planningConstraints,
     * linkedRevisions, linkedRevisionsDerived, linkedOslcResources, attachments,
     * outlineNumber
     * 
     * Use other methods to adjust your Work Item e.g. createComment, addHyperlink,
     * addAssignee, addLinkedItem, addCategory.
     * @param content The content of the Work Item to be created.
     */
    public java.lang.String createWorkItem(com.polarion.alm.ws.client.types.tracker.WorkItem content) throws java.rmi.RemoteException;

    /**
     * Creates a Work Item at a specified position inside the Module/Document.
     * @param moduleURI The Module/Document URI.
     * @param parentWorkItemURI The URI of the parent Work Item or null.
     * @param workItem The content of the Work Item to be created.
     * @return The URI of the created Work Item.
     * @since 3.4.1
     */
    public java.lang.String createWorkItemInModule(java.lang.String moduleURI, java.lang.String parentWorkItemURI, com.polarion.alm.ws.client.types.tracker.WorkItem workItem) throws java.rmi.RemoteException;

    /**
     * Creates a Work Record.
     * @param workitemURI The URI of the Work Item to create a Work Record
     * for.
     * @param user The user for the Work Record.
     * @param date The date of the Work Record.
     * @param timeSpent The time spent for the Work Record.
     */
    public void createWorkRecord(java.lang.String workitemURI, com.polarion.alm.ws.client.types.projects.User user, java.util.Date date, java.lang.String timeSpent) throws java.rmi.RemoteException;

    /**
     * Creates a Work Record.
     * @param workitemURI The URI of the Work Item to create a Work Record
     * for.
     * @param user The user for the Work Record.
     * @param date The date of the Work Record.
     * @param type The Work Record Type.
     * @param timeSpent The time spent on the Work Record.
     * @param comment The Work Record comment.
     * @since 3.4.2
     */
    public void createWorkRecordWithTypeAndComment(java.lang.String workitemURI, com.polarion.alm.ws.client.types.projects.User user, java.util.Date date, com.polarion.alm.ws.client.types.tracker.EnumOptionId type, java.lang.String timeSpent, java.lang.String comment) throws java.rmi.RemoteException;

    /**
     * Remove an attachment.
     * @param workitemURI The URI of the Work Item containing the attachment
     * to be removed.
     * @param id The Id of the attachment to be removed.
     * @since 3.3.1
     */
    public void deleteAttachment(java.lang.String workitemURI, java.lang.String id) throws java.rmi.RemoteException;

    /**
     * Deletes the given Baseline.
     * @param baselineURI The Baseline SubterraURI (not null).
     * @since 3.7.1
     */
    public void deleteBaseline(java.lang.String baselineURI) throws java.rmi.RemoteException;

    /**
     * Deletes a Module/Document.
     * @param moduleURI The URI of the Module/Document.
     * @since 3.4.1
     */
    public void deleteModule(java.lang.String moduleURI) throws java.rmi.RemoteException;

    /**
     * Deletes a Work Item.
     * @param workitemURI The URI of the Work Item.
     * @since 3.20.1
     */
    public void deleteWorkItem(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Deletes a Work Record.
     * @param workitemURI The URI of the Work Item to remove the work record
     * from.
     * @param workRecordURI The URI of the Work Record to remove.
     */
    public void deleteWorkRecord(java.lang.String workitemURI, java.lang.String workRecordURI) throws java.rmi.RemoteException;

    /**
     * Triggers auto suspect.
     * @param workitemURI The URI of the work item to trigger auto suspect
     * for.
     */
    public void doAutoSuspect(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Triggers autoassignement.
     * @param workitemURI The URI of the Work Item to trigger autoassignement
     * for.
     */
    public void doAutoassign(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Changes the status of an approval.
     * @param workitemURI The URI of the Work Item to execute the action
     * for.
     * @param approveeId The Id of the approvee.
     * @param status The new status to set.
     */
    public void editApproval(java.lang.String workitemURI, java.lang.String approveeId, com.polarion.alm.ws.client.types.tracker.EnumOptionId status) throws java.rmi.RemoteException;

    /**
     * Export and download a document to PDF.
     * @param uri Module/Document URI.
     * @param exportPdfProperties Export parameters. They contain the following
     * properties: 
     * 	paperSize - The size of the exported page. Possible values are A4
     * (Default), A3, Letter, Legal and Tabloid. 
     * 	orientation - The orientation of the page. Possible values are Portrait
     * (Default) and Landscape. 
     * 	fitToPageWidth - Set to True to fit the content to the width of the
     * page. Default is True. 
     * 	generateBookmarks - Set to True to generate bookmarks. Default is
     * False. 
     * 	includeHeaderFooter - Set to True to include a header, footer, and
     * watermark. Default is True. 
     * 	repeatTableHeaders - Set to True to repeat table headers on every
     * page. Default is True.
     * @since 3.20.1
     */
    public byte[] exportDocumentToPDF(java.lang.String uri, com.polarion.alm.ws.client.types.tracker.PdfProperties exportPdfProperties) throws java.rmi.RemoteException;

    /**
     * Gets the Work Item's history.
     * @param workitemURI The URI of the Work Item to get the history for.
     * @param ignoredFields The fields that will be ignored (can be null).
     * @param fieldOrder The order of fields (can be null).
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.tracker.Change[] generateHistory(java.lang.String workitemURI, java.lang.String[] ignoredFields, java.lang.String[] fieldOrder) throws java.rmi.RemoteException;

    /**
     * Returns the Activity with the given global Id.
     * @param activityGlobalId The Activity's global Id.
     * @return The Activity.
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.tracker.Activity getActivityByGlobalId(java.lang.String activityGlobalId) throws java.rmi.RemoteException;

    /**
     * Gets all enumeration option IDs.
     * @param projectID The ID of the Project to get the options for.
     * @param enumId The Id of the enumeration to get the options for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOptionId[] getAllEnumOptionIdsForId(java.lang.String projectID, java.lang.String enumId) throws java.rmi.RemoteException;

    /**
     * Gets all enumeration option IDs.
     * @param projectID The Id of the Project to get the options for.
     * @param key The key of the field containing the enumeration to get
     * the option Id for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOptionId[] getAllEnumOptionIdsForKey(java.lang.String projectID, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets all enumeration options.
     * @param projectID The Id of the Project to get the options for.
     * @param enumID The Id of the enumeration to get the options for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getAllEnumOptionsForId(java.lang.String projectID, java.lang.String enumID) throws java.rmi.RemoteException;

    /**
     * Gets all enumeration options.
     * @param projectID The Id of the Project to get the options for.
     * @param key The key of the field containing the enumeration to get
     * the options for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getAllEnumOptionsForKey(java.lang.String projectID, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets all allowed approvers.
     * @param workitemURI The URI of the Work Item to get the allowed approvers
     * for.
     * @since 3.5.3
     */
    public com.polarion.alm.ws.client.types.projects.User[] getAllowedApprovers(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Gets all allowed assignees.
     * @param workitemURI The URI of the Work Item to get the allowed assignees
     * for.
     */
    public com.polarion.alm.ws.client.types.projects.User[] getAllowedAssignees(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Download an attachment.
     * @param workitemURI The URI of the Work Item.
     * @param attachmentId The ID of the attachment.
     * @since 3.20.1
     */
    public byte[] getAttachment(java.lang.String workitemURI, java.lang.String attachmentId) throws java.rmi.RemoteException;

    /**
     * Gets the actions that can be used on the workflow object in
     * its current state.
     * The conditions of the action are checked and those with failed condition(s)
     * are not returned.
     * NOTE: The parameter name {@code workitemURI} is kept for backward
     * compatibility,
     * but the specified URI can refer to any WorkflowObject, e.g. WorkItem
     * or Module.
     * @param workitemURI The URI of the WorkflowObject to get the available
     * actions from. (Should not be {@code null}.)
     * @return The available actions.
     * @throws IllegalArgumentException if parameter is {@code null}
     * @see #performWorkflowAction(java.lang.String, int)
     * @see #getUnavailableActions(java.lang.String)
     */
    public com.polarion.alm.ws.client.types.tracker.WorkflowAction[] getAvailableActions(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Gets the available enumeration option IDs.
     * @param workitemURI The URI of the Work Item to get the enumeration
     * option IDs for.
     * @param enumID The Id of the enumeration to get the option IDs for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOptionId[] getAvailableEnumOptionIdsForId(java.lang.String workitemURI, java.lang.String enumID) throws java.rmi.RemoteException;

    /**
     * Gets the available enumeration option IDs.
     * @param workitemURI The URI of the Work Item to get the enumeration
     * option IDs for.
     * @param key The Id of the enumeration to get the available option IDs
     * for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOptionId[] getAvailableEnumOptionIdsForKey(java.lang.String workitemURI, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets the back linked Work Items.  (Work Items linking to the
     * specified Work Item.)
     * @param workitemURI The URI of the Work Item to get the back links
     * for.
     */
    public com.polarion.alm.ws.client.types.tracker.LinkedWorkItem[] getBackLinkedWorkitems(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Get the categories defined for the give project id.
     */
    public com.polarion.alm.ws.client.types.tracker.Category[] getCategories(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Returns list of folders contained in this folder.
     * @param projectId The project ID or null for the Global level.
     * @param parentFolderId The parent folder name (ID).
     * @return An array of child folders from this parent folder.
     * @since 3.18.1
     */
    public com.polarion.alm.ws.client.types.tracker.Folder[] getChildFolders(java.lang.String projectId, java.lang.String parentFolderId) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item's custom field.
     * @param workitemURI The URI of the Work Item to get the custom field
     * from.
     * @param key The custom field's key.
     */
    public com.polarion.alm.ws.client.types.tracker.CustomField getCustomField(java.lang.String workitemURI, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets the names of defined custom fields.
     * @param workitemURI the URI of the work item to get the defined custom
     * fields for.
     */
    public java.lang.String[] getCustomFieldKeys(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Gets the custom field definitions for a specific Work Item.
     * @param workitemURI The URI of the Work Item.
     * @param key The key of the custom field.
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType getCustomFieldType(java.lang.String workitemURI, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets all custom field definitions for a specific Work Item.
     * @param workitemURI The URI of the Work Item.
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType[] getCustomFieldTypes(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Returns the language definition for the default language. (Primarily
     * to provide its label).
     * @param projectId The Project Id (not null).
     * @return The language definition or null if one is not defined.
     * @since 3.6.1
     */
    public com.polarion.alm.ws.client.types.tracker.LanguageDefinition getDefaultLanguageDefinition(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets all custom field keys defined for a Work Item Type in
     * a Project.
     * @param projectID The Id of the Project.
     * @param typeID The Work Item Type Id.
     */
    public java.lang.String[] getDefinedCustomFieldKeys(java.lang.String projectID, java.lang.String typeID) throws java.rmi.RemoteException;

    /**
     * Gets a custom field definition for a Work Item Type.
     * @param projectID The Id of the Project.
     * @param typeID The Work Item Type Id.
     * @param key key of the custom field.
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType getDefinedCustomFieldType(java.lang.String projectID, java.lang.String typeID, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets all custom field definitions for a Work Item Type.
     * @param projectID The Id of the Project.
     * @param typeID The Work Item Type Id.
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType[] getDefinedCustomFieldTypes(java.lang.String projectID, java.lang.String typeID) throws java.rmi.RemoteException;

    /**
     * Returns Module/Document Spaces from given Project.
     * @param projectId The Project Id (not null).
     * @return An array of Space IDs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] getDocumentSpaces(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets duration time in hours
     * @param duration The string representation of the duration time.
     * @since 3.3.0
     */
    public float getDurationHours(java.lang.String duration) throws java.rmi.RemoteException;

    /**
     * Gets the enumeration control key for the specified Work Item
     * key.
     * @param projectID The Id of the Project.
     * @param enumID The Id of the enumeration to get the control key for.
     */
    public java.lang.String getEnumControlKeyForId(java.lang.String projectID, java.lang.String enumID) throws java.rmi.RemoteException;

    /**
     * Gets the enumeration control key for the specified Work Item
     * key.
     * @param projectID The Id of the Project.
     * @param key The key of the field containing the enumeration to get
     * the control key for.
     */
    public java.lang.String getEnumControlKeyForKey(java.lang.String projectID, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Returns an instance of the IEnumOption of a given object URI
     * and the enumeration Id.
     * @param uri The SubterraURI (not null).
     * @param enumId The Id of the enumeration.
     * @return An instance of IEnumOption (not null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption getEnumOptionFromObjectUriForId(java.lang.String uri, java.lang.String enumId) throws java.rmi.RemoteException;

    /**
     * Returns an instance of the IEnumOption of a given object URI,
     * the Prototype name and the prototype object's key.
     * @param uri The SubterraURI (not null)
     * @param prototypeName The Prototype name.
     * @param key The key of the given prototype object.
     * @return The instance of the IEnumOption (not null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption getEnumOptionFromObjectUriForKey(java.lang.String uri, java.lang.String prototypeName, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets an enumeration option.
     * @param workitemURI The URI of the Work Item to get the enumeration
     * option for.
     * @param enumID The Id of the enumeration.
     * @param id The enumeration option Id.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption getEnumOptionWithEnumId(java.lang.String workitemURI, java.lang.String enumID, com.polarion.alm.ws.client.types.tracker.EnumOptionId id) throws java.rmi.RemoteException;

    /**
     * Gets an enumeration option.
     * @param workitemURI The URI of the Work Item to get the enumeration
     * option for.
     * @param key The key of the field containing the enumeration option
     * value.
     * @param id The enumeration option Id.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption getEnumOptionWithKey(java.lang.String workitemURI, java.lang.String key, com.polarion.alm.ws.client.types.tracker.EnumOptionId id) throws java.rmi.RemoteException;

    /**
     * Gets the available enumeration options.
     * @param workitemURI The URI of the Work Item to get the enumeration
     * options for.
     * @param enumID The id of the enumeration to get the options for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getEnumOptionsForId(java.lang.String workitemURI, java.lang.String enumID) throws java.rmi.RemoteException;

    /**
     * Gets the available enumeration options.
     * The control value is the string representation of the Work Item value
     * at the field specified by the enumerations control key.
     * @see #getEnumControlKeyForKey
     * @see #getEnumControlKeyForId
     * @param projectID The Id of the Project to get the options for.
     * @param enumID The Id of the enumeration to get the options for.
     * @param controlValue The string representation of the control value.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getEnumOptionsForIdWithControl(java.lang.String projectID, java.lang.String enumID, java.lang.String controlValue) throws java.rmi.RemoteException;

    /**
     * Gets the available enumeration options.
     * @param workitemURI The URI of the Work Item to get the enumeration
     * options for.
     * @param key The key of the field containing the enumeration to get
     * the options for.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getEnumOptionsForKey(java.lang.String workitemURI, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets the available enumeration options.
     * The control value is the string representation of the Work Item value
     * on the field specified by the enumerations control key.
     * @see #getEnumControlKeyForKey
     * @see #getEnumControlKeyForId
     * @param projectID The Id of the Project to get the options for.
     * @param key The key of the field containing the enumeration to get
     * the options for.
     * @param controlValue The string representation of the control value.
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getEnumOptionsForKeyWithControl(java.lang.String projectID, java.lang.String key, java.lang.String controlValue) throws java.rmi.RemoteException;

    /**
     * Gets the available, filtered enumeration options.
     * @param uri The URI of the peristent object to get the enumeration
     * options for (not null).
     * @param key The key of the field containing the enumeration to get
     * the options for (not null).
     * @param filter The Id of the enumeration option to use as the "from"
     * value for the dependency mapping. (Can be null.)
     * @since 3.8.1
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getFilteredEnumOptionsForKey(java.lang.String uri, java.lang.String key, java.lang.String filter) throws java.rmi.RemoteException;

    /**
     * Returns a folder specified by the Project and Folder name.
     * @param projectId The Project Id or null for the Global level.
     * @param folderName The name of the folder. (Not null.) 
     * @return The folder from the given Project or on the Global level.(Not
     * null.)
     * @since 3.8.3
     */
    public com.polarion.alm.ws.client.types.tracker.Folder getFolder(java.lang.String projectId, java.lang.String folderName) throws java.rmi.RemoteException;

    /**
     * Returns the folder that the specified object is contained in.
     * The object must implement the IFolderItem interface (e.g. Module).
     * Otherwise returns null.
     * @param objectURI The URI of the object. (Not null.)
     * @return Folder for specified object. (Can be null.)
     * @since 3.8.3
     */
    public com.polarion.alm.ws.client.types.tracker.Folder getFolderForURI(java.lang.String objectURI) throws java.rmi.RemoteException;

    /**
     * Returns folders from the given Project or on the Global level.
     * @param projectId The project Id or null for the Global level.
     * @return An array of folders contained within the given Project or
     * on the Global level.
     * @since 3.8.3
     */
    public com.polarion.alm.ws.client.types.tracker.Folder[] getFolders(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets the initial workflow action for the specified object and
     * returns {@code null} if there is no initial action for the corresponding
     * workflow.
     * NOTE: The parameter name {@code workitemURI} is kept for backward
     * compatibility,
     * but the specified URI can refer to any WorkflowObject, e.g. WorkItem
     * or Module.
     * @param workitemURI The URI of the WorkflowObject to get the available
     * actions from. (Should not be {@code null}.)
     * @return The initial workflow action, {@code null} if no action is
     * configured.
     * @throws IllegalArgumentException if parameter is {@code null}
     * @see #resetWorkflow(java.lang.String)
     * @since 3.4.3
     */
    public com.polarion.alm.ws.client.types.tracker.WorkflowAction getInitialWorkflowAction(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Gets the initial workflow action for a specific Work Item Type
     * in the specific Project.
     * @param projectId The Id of the Project to get the Work Item from.
     * @param wiType The Work Item Type to get the available actions from.
     * (Should not be {@code null}.)
     * @return The initial workflow action, {@code null} if no initial action
     * is configured.
     * @throws IllegalArgumentException if wiType is {@code null}
     * @see #getInitialWorkflowAction(java.lang.String)
     * @since 3.6.1
     */
    public com.polarion.alm.ws.client.types.tracker.WorkflowAction getInitialWorkflowActionForProjectAndType(java.lang.String projectId, com.polarion.alm.ws.client.types.tracker.EnumOptionId wiType) throws java.rmi.RemoteException;

    /**
     * Returns the language definition for a given language.
     * @param projectId The Project Id (not null).
     * @param language The language Id (not null).
     * @return The language definition or null if one is not defined.
     * @since 3.6.1
     */
    public com.polarion.alm.ws.client.types.tracker.LanguageDefinition getLanguageDefinition(java.lang.String projectId, java.lang.String language) throws java.rmi.RemoteException;

    /**
     * Returns all language definitions. (Does not include the default
     * language definition).
     * @param projectId The Project Id (not null).
     * @return All language definitions.
     * @since 3.6.1
     */
    public com.polarion.alm.ws.client.types.tracker.LanguageDefinition[] getLanguageDefinitions(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Returns a set of resources linked to the Work Item.
     * @param workitemURI The URI of the Work Item to get linked resources
     * from.
     * @return An array of Linked Resources for the specified Work Item.
     * @since 3.17.0
     */
    public com.polarion.alm.ws.client.types.tracker.LinkedResource[] getLinkedResources(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Returns the localized description or the normal description
     * if the localized one is not defined or is empty.
     * @param uri The Work Item URI (not null).
     * @param language The language Id or null for the default language.
     * @return The localized description (can be null).
     * @since 3.6.1
     */
    public com.polarion.alm.ws.client.types.Text getLocalizedWorkItemDescription(java.lang.String uri, java.lang.String language) throws java.rmi.RemoteException;

    /**
     * Returns the Id of the field of a Work Item of a given Type
     * that stores the localized description.
     * @param projectId The Project Id (not null).
     * @param language The language Id (not null).
     * @param type The Work Item Type (not null).
     * @return The Id of the field or null if it is not defined.
     * @since 3.6.1
     */
    public java.lang.String getLocalizedWorkItemDescriptionField(java.lang.String projectId, java.lang.String language, com.polarion.alm.ws.client.types.tracker.EnumOptionId type) throws java.rmi.RemoteException;

    /**
     * Returns the localized title or normal title if the localized
     * one is not defined or is empty.
     * @param uri The Work Item URI (not null).
     * @param language The language Id or null for the default language.
     * @return The localized title (can be null).
     * @since 3.6.1
     */
    public java.lang.String getLocalizedWorkItemTitle(java.lang.String uri, java.lang.String language) throws java.rmi.RemoteException;

    /**
     * Returns the Id of the field of a Work Item of a given Type
     * that stores the localized title.
     * @param projectId The Project Id (not null).
     * @param language The language Id (not null).
     * @param type The Work Item Type (not null).
     * @return The Id of the field or null if one is not defined.
     * @since 3.6.1
     */
    public java.lang.String getLocalizedWorkItemTitleField(java.lang.String projectId, java.lang.String language, com.polarion.alm.ws.client.types.tracker.EnumOptionId type) throws java.rmi.RemoteException;

    /**
     * Retrieves the Module/Document on the given location.
     * @param projectId The Project Id.
     * @param location The encoded location of a retrieved Module/Document,
     * relative to the Module/Document root in the given Project.
     * 	Use the location with a revision set to retrieve a particular revision
     * of the Module/Document.
     * @since 3.4.1
     */
    public com.polarion.alm.ws.client.types.tracker.Module getModuleByLocation(java.lang.String projectId, java.lang.String location) throws java.rmi.RemoteException;

    /**
     * Retrieves the Module/Document on the given location with the
     * given fields set.
     * @param projectId The Project Id.
     * @param location The encoded location of retrieved Module/Document,
     * relative to Module/Document root in the given project.
     * 	Use the location with a revision set to retrieve a particular revision
     * of the Module/Document.
     * @param fields The fields to fill in. For nested structures in the
     * lists, use the following syntax to only include a subset of fields:
     * myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled using the following
     * syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.4.1
     */
    public com.polarion.alm.ws.client.types.tracker.Module getModuleByLocationWithFields(java.lang.String projectId, java.lang.String location, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Gets Module/Document with all fields filled.
     * @param uri Module/Document URI
     * @since 3.4.1
     */
    public com.polarion.alm.ws.client.types.tracker.Module getModuleByUri(java.lang.String uri) throws java.rmi.RemoteException;

    /**
     * Gets a Module/Document with given fields filled in.
     * @param uri Module/Document URI
     * @param fields The fields to fill in. For nested structures in the
     * lists, use the following syntax to  only include a subset of fields:
     * myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.4.1
     */
    public com.polarion.alm.ws.client.types.tracker.Module getModuleByUriWithFields(java.lang.String uri, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Returns the Modules/Documents residing on the given location
     * relative to the "modules" folder of the given project.
     * @param projectId The Project Id (not null).
     * @param location The serialized location relative to the "modules"
     * folder.
     * @return An array of Modules/Documents SubterraURIs. (One Module/Document
     * SubterraURI if the location is the location of the Module/Document;
     * can be null.)
     * @since 3.6.3
     */
    public java.lang.String[] getModuleUris(java.lang.String projectId, java.lang.String location) throws java.rmi.RemoteException;

    /**
     * Returns the URIs of Work Items contained in a given Module/Document
     * under given parent
     * (if specified).
     * @param moduleURI The Module/Document URI.
     * @param parentWorkItemURI The URI of the parent Work Item or null.
     * @param deep true to return Work Items from the whole subtree.
     * @since 3.4.1
     */
    public java.lang.String[] getModuleWorkItemUris(java.lang.String moduleURI, java.lang.String parentWorkItemURI, boolean deep) throws java.rmi.RemoteException;

    /**
     * Returns Work Items (with given fields set) contained in a given
     * Module/Document under the given parent
     * (if specified).
     * @param moduleURI The Module/Document URI.
     * @param parentWorkItemURI The URI of parent Work Item or null.
     * @param deep true to return Work Items from the whole subtree.
     * @param fields The fields to fill in. For nested structures in the
     * lists, use the following syntax to only include a subset of fields:
     * myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.4.1
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] getModuleWorkItems(java.lang.String moduleURI, java.lang.String parentWorkItemURI, boolean deep, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Returns the Modules/Documents residing on the given location
     * relative to the "modules" folder of the given project.
     * @param projectId The Project Id (not null).
     * @param location The serialized location relative to the "modules"
     * folder.
     * @return An array of Modules/Documents. (One Module/Document if the
     * location is the location of the Module/Document; can be null.)
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.Module[] getModules(java.lang.String projectId, java.lang.String location) throws java.rmi.RemoteException;

    /**
     * Returns the sub-folders of a given location relative to the
     * "modules" folder of the given Project.
     * @param projectId The Project Id (not null).
     * @param location The serialized location relative to the "modules"
     * folder.
     * @return  An array of serialized locations (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] getModulesSubFolders(java.lang.String projectId, java.lang.String location) throws java.rmi.RemoteException;

    /**
     * Returns the Modules/Documents residing on the given location
     * relative to the "modules" folder of the given project.
     * @param projectId The Project Id (not null).
     * @param location The serialized location relative to the "modules"
     * folder.
     * @param fields An array of field names to fill in the returned Modules/Documents
     * (can be null). For nested structures in the lists, use the following
     * syntax to only include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @return An array of Modules/Documents. (One Module/Document if the
     * location is the location of the Module/Document; can be null.)
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.Module[] getModulesWithFields(java.lang.String projectId, java.lang.String location, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Gets the length of one day
     * @since 3.2.3
     */
    public long getOneDayLength() throws java.rmi.RemoteException;

    /**
     * Gets a revision.
     * @param repositoryName The repository name. (Put "default" for the
     * default repository.)
     * @param revisionId The revision name.
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.Revision getRevision(java.lang.String repositoryName, java.lang.String revisionId) throws java.rmi.RemoteException;

    /**
     * Gets a revision.
     * @param revisionURI The URI of the revision.
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.Revision getRevisionByUri(java.lang.String revisionURI) throws java.rmi.RemoteException;

    /**
     * Returns all revisions for a specific URI.
     * @param in0 uri the URI of the persistence object (Work Item, Module/Document,
     * User, etc).
     * @return all revisions for the specific URI.
     * @since 3.4.3
     */
    public java.lang.String[] getRevisions(java.lang.String in0) throws java.rmi.RemoteException;

    /**
     * Returns parent folders from the given Project or on the Global
     * level. Sorted in ascending order by name (or title if present).
     * @param projectId The project ID or null for the Global level.
     * @return An array of folders contained within the given Project or
     * on the Global level.
     * @since 3.18.1
     */
    public com.polarion.alm.ws.client.types.tracker.Folder[] getRootFolders(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets the time points available for a Project.
     * @param projectId The Id of the Projects to get the available time
     * points for.
     */
    public com.polarion.alm.ws.client.types.tracker.TimePoint[] getTimepoints(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets the actions that can not be used on the Work Item in the
     * current state
     * because of unsatisfied condition(s).
     * The conditions of the action are checked and those with failed condition(s)
     * are returned.
     * The reason for unavailability is returned by {@link com.polarion.alm.ws.client.types.tracker.WorkflowAction#getUnavailabilityMessage()}.
     * NOTE: The parameter name {@code workitemURI} is kept for backward
     * compatibility,
     * but the specified URI can refer to any WorkflowObject, e.g. WorkItem
     * or Module.
     * @param workitemURI the URI of the WorkflowObject to get the available
     * actions from. (should not be {@code null})
     * @return the unavailable actions
     * @throws IllegalArgumentException if parameter is {@code null}
     * @see #performWorkflowAction(java.lang.String, int)
     * @see #getAvailableActions(java.lang.String)
     * @since 3.6.1
     */
    public com.polarion.alm.ws.client.types.tracker.WorkflowAction[] getUnavailableActions(java.lang.String workitemURI) throws java.rmi.RemoteException;

    /**
     * Returns a Wiki Page with the given SubterraURI.
     * @param uri The SubterraURI (not null).
     * @return The Wiki Page (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage getWikiPageByUri(java.lang.String uri) throws java.rmi.RemoteException;

    /**
     * Returns a Wiki Page with the given SubterraURI.
     * @param uri The SubterraURI (not null).
     * @param fields An array of field names to fill in on the returned Wiki
     * Pages (can be null).
     * @return The Wiki Page (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage getWikiPageByUriWithFields(java.lang.String uri, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Returns Wiki Pages from a given Project and Space.
     * @param projectId The Project Id (not null).
     * @param spaceId The Space Id (not null).
     * @return An array of Wiki Pages SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] getWikiPageUris(java.lang.String projectId, java.lang.String spaceId) throws java.rmi.RemoteException;

    /**
     * Returns Wiki Pages from a given Project and Space.
     * @param projectId The Project Id (not null).
     * @param spaceId The Space Id (not null).
     * @return An array of Wiki Pages (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage[] getWikiPages(java.lang.String projectId, java.lang.String spaceId) throws java.rmi.RemoteException;

    /**
     * Returns Wiki Pages from a given Project and Space.
     * @param projectId The Project Id (not null).
     * @param spaceId Space Id (not null).
     * @param fields An array of field names to filled in on the returned
     * Wiki Pages (can be null).
     * @return An array of Wiki Pages (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage[] getWikiPagesWithFields(java.lang.String projectId, java.lang.String spaceId, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Returns Wiki spaces from a given Project.
     * @param projectId The Project Id (not null).
     * @return An array of Space Ids (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] getWikiSpaces(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item with all fields set.
     * @param projectId The Id of the project that contains the Work Item
     * to get.
     * @param workitemId The Id of the Work Item to get.
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem getWorkItemById(java.lang.String projectId, java.lang.String workitemId) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item with only the fields specified filled in with
     * values. All other fields are not transmitted.
     * @param projectId The Id of the project that contains the Work Item
     * to get.
     * @param workitemId The Id of the Work Item to get.
     * @param keys The fields of the Work Item to fill in. For nested structures
     * in the lists, use the following syntax to only include a subset of
     * fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem getWorkItemByIdsWithFields(java.lang.String projectId, java.lang.String workitemId, java.lang.String[] keys) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item with all fields set.
     * @param uri the URI of the work item to get.
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem getWorkItemByUri(java.lang.String uri) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item in the given revision with all fields set.
     * Returns null if the work item did not exist in the revision.
     * @param uri The URI of the Work Item to get.
     * @param revision The revision of the Work Item to get.
     * @since 3.4.2
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem getWorkItemByUriInRevision(java.lang.String uri, java.lang.String revision) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item in a given revision with only the fields specified
     * filled in with values. All other fields are not transmitted.
     * Returns null if the Work Item does not exist in the revision.
     * @param uri The URI of the Work Item to get.
     * @param revision The revision of the Work Item to get.
     * @param keys The fields of the Work Item to fill in. For nested structures
     * in the lists, use the following syntax to only include a subset of
     * fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.4.2
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem getWorkItemByUriInRevisionWithFields(java.lang.String uri, java.lang.String revision, java.lang.String[] keys) throws java.rmi.RemoteException;

    /**
     * Gets a Work Item with only the fields specified filled in with
     * values. All other fields are not transmitted.
     * @param uri The URI of the Work Item to get.
     * @param keys The fields of the Work Item to fill in. For nested structures
     * in the lists, use the following syntax to only include a subset of
     * fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem getWorkItemByUriWithFields(java.lang.String uri, java.lang.String[] keys) throws java.rmi.RemoteException;

    /**
     * Counts the number of Work Items returned by the given query.
     * @param query The Lucene query to be used.
     * @since 3.3.0
     */
    public int getWorkItemsCount(java.lang.String query) throws java.rmi.RemoteException;

    /**
     * Gets Work Items linked to a revision.
     * @param revisionURI The URI of the revision.
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] getWorkItemsLinkedToRevision(java.lang.String revisionURI) throws java.rmi.RemoteException;

    /**
     * Gets Work Items linked to a revision.
     * @param revisionURI The URI of the revision.
     * @param keys The keys of the fields that should be filled in. For nested
     * structures in the lists, use the following syntax to only include
     * a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] getWorkItemsLinkedToRevisionWithFields(java.lang.String revisionURI, java.lang.String[] keys) throws java.rmi.RemoteException;

    /**
     * Returns true if the History is available.
     * @return true if the History is available. Otherwise false.
     * @since 3.7.1
     */
    public boolean isHistoryAvailable() throws java.rmi.RemoteException;

    /**
     * Checks if the comment is in a resolved comments thread.
     * @param commentURI The URI of the comment.
     * @since 3.7.1
     */
    public boolean isResolvedComment(java.lang.String commentURI) throws java.rmi.RemoteException;

    /**
     * Returns all Activity Sources.
     * @return array of Activity sources.
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.tracker.ActivitySource[] listActivitySources() throws java.rmi.RemoteException;

    /**
     * Returns Activities within the default repository.
     * @param query The Lucene query (can be null).
     * @param count The number of results. (-1 will return all results.)
     * @return An array of Activities.
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.tracker.Activity[] listAllActivities(java.lang.String query, int count) throws java.rmi.RemoteException;

    /**
     * Returns the Activity global IDs within the default repository.
     * @param query The Lucene query (can be null).
     * @param count The number of results. (-1 will return all results.)
     * @return An array of Activity global IDs.
     * @since 3.7.0
     */
    public java.lang.String[] listAllActivitiesGlobalIds(java.lang.String query, int count) throws java.rmi.RemoteException;

    /**
     * Returns Activities within a given Project group.
     * @param uri The SubterraURI (not null).
     * @param query The Lucene query (can be null).
     * @param count The number of results. (-1 will return all results.)
     * @return An array of Activities.
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.tracker.Activity[] listGroupActivities(java.lang.String uri, java.lang.String query, int count) throws java.rmi.RemoteException;

    /**
     * Returns global IDs of activities within given project group.
     * @param uri The SubterraURI (not null).
     * @param query The Lucene query (can be null).
     * @param count The number of results. (-1 will return all results.)
     * @return An array of Activity global IDs.
     * @since 3.7.0
     */
    public java.lang.String[] listGroupActivitiesGlobalIds(java.lang.String uri, java.lang.String query, int count) throws java.rmi.RemoteException;

    /**
     * Returns activities within the given Project.
     * @param projectId The Id of the Project (not null).
     * @param query The Lucene query (can be null).
     * @param count The number of results. (-1 will return all results.)
     * @return An array of Activities.
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.tracker.Activity[] listProjectActivities(java.lang.String projectId, java.lang.String query, int count) throws java.rmi.RemoteException;

    /**
     * Returns the global IDs of Activities within the given Project.
     * @param projectId The Id of the Project (not null).
     * @param query The Lucene query (can be null).
     * @param count The number of results. (-1 will return all results.)
     * @return An array of Activity global IDs.
     * @since 3.7.0
     */
    public java.lang.String[] listProjectActivitiesGlobalIds(java.lang.String projectId, java.lang.String query, int count) throws java.rmi.RemoteException;

    /**
     * Moves a Work Item to a specific position in a Document.
     *  If the Work Item is not yet inside the Document it will be moved
     * into the Document.
     *  Modules are also supported.
     * 	
     * @param workItemURI The URI of the Work Item to be moved.
     * 	
     * @param documentURI The URI of the Document.
     * 	
     * @param parentWorkItemURI The URI of the parent Work Item or {@code
     * null} to insert it as the root.
     * 	
     * @param position The desired position in the list of children or a
     * value < 0 to insert the Work Item at the end. 
     * 	(If the old and new parent are the same, then the moved Work Item
     * is not counted.)
     * 	
     * @param retainDocumentFlow {@code true} to retain the position of the
     * moved Work Item in the document flow, even if it means changing the
     * parent.
     * 	{@code false} to keep the desired parent, even if it means moving
     * the Work Item to a different position.
     * 	
     * @since 3.7.0
     */
    public void moveWorkItemToDocument(java.lang.String workItemURI, java.lang.String documentURI, java.lang.String parentWorkItemURI, int position, boolean retainDocumentFlow) throws java.rmi.RemoteException;

    /**
     * Moves a Work Item to a specific position in a Module/Document.
     * If the Work Item is not yet inside the Module/Document it will be
     * moved there.
     *  Since 3.7.0 this no longer retains the document flow, but keeps the
     * desired parent.
     * 	
     * @param workItemURI The URI of the Work Item to be moved.
     * 	
     * @param moduleURI The URI of the Module/Document.
     * 	
     * @param parentWorkItemURI The URI of the parent Work Item or {@code
     * null} to insert it as the root.
     * 	
     * @param position The desired position in the list of children or a
     * value < 0 to insert at the end. 
     * 	(If the old and new parent are the same, then the moved Work Item
     * is not counted.)
     * 	
     * @deprecated Use {@link #moveWorkItemToDocument(String, String, String,
     * int, boolean)}.
     * 	
     * @since 3.4.3
     */
    public void moveWorkItemToModule(java.lang.String workItemURI, java.lang.String moduleURI, java.lang.String parentWorkItemURI, int position) throws java.rmi.RemoteException;

    /**
     * Executes a workflow action.
     * The actions that can be performed can be received by {@link #getAvailableActions(java.lang.String)}.
     * The workflow action is specified by {@link com.polarion.alm.ws.client.types.tracker.WorkflowAction#getActionId()}.
     * NOTE: The parameter name {@code workitemURI} is kept for backward
     * compatibility,
     * but the specified URI can refer to any WorkflowObject, e.g. WorkItem
     * or Module.
     * @param workitemURI The URI of the WorkflowObject to execute the action
     * for (should not be {@code null}).
     * @param actionId The Id of the action to execute.
     * @throws IllegalArgumentException if workitemURI parameter is {@code
     * null}
     * @see #getAvailableActions(java.lang.String)
     */
    public void performWorkflowAction(java.lang.String workitemURI, int actionId) throws java.rmi.RemoteException;

    /**
     * Queries for Baselines.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @since 3.4.2
     */
    public com.polarion.alm.ws.client.types.tracker.Baseline[] queryBaselines(java.lang.String query, java.lang.String sort) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param resultsLimit Set a limit on how many results to return. (-1
     * for unlimited.) 
     * @return An array of Modules/Documents SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryModuleUris(java.lang.String query, java.lang.String sort, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents.
     * @param sqlQuery The SQL statement.
     * @return An array of Modules/Documents SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryModuleUrisBySQL(java.lang.String sqlQuery) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents in a given Baseline.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The Baseline revision.
     * @param resultsLimit Set a limit on how many results to return. (-1
     * for unlimited.) 
     * @return An array of Modules/Documents SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryModuleUrisInBaseline(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents in a given Baseline.
     * @param sqlQuery The SQL statement.
     * @param baselineRevision The Baseline revision.
     * @return An array of Modules/Documents SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryModuleUrisInBaselineBySQL(java.lang.String sqlQuery, java.lang.String baselineRevision) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields An array of field names to fill in the returned Modules/Documents
     * with. (Can be null.) For nested structures in the lists, use the following
     * syntax to only include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @param resultsLimit Sets a limit on the number of results to return.(-1
     * to return all results without a limit.)
     * @return An array of Modules/Documents (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.Module[] queryModules(java.lang.String query, java.lang.String sort, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents.
     * @param sqlQuery The SQL statement.
     * @param fields An array of field names to fill in the returned Modules/Documents
     * with. (Can be null.) For nested structures in the lists, use the following
     * syntax to only include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @return An array of Modules/Documents (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.Module[] queryModulesBySQL(java.lang.String sqlQuery, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Searches for the Modules/Documents in a given Baseline.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The Baseline revision
     * @param fields An array of field names to fill in the returned Modules/Documents
     * with. (Can be null.) For nested structures in the lists, use the following
     * syntax to only include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @param resultsLimit how many results to return (-1 means everything)
     * @return An array of Modules/Documents (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.Module[] queryModulesInBaseline(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Modules/Documents in a given Baseline.
     * @param sqlQuery The SQL statement.
     * @param baselineRevision The Baseline revision.
     * @param fields An array of field names to fill in the returned Modules/Documents
     * with. (Can be null.) For nested structures in the lists, use the following
     * syntax to only include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @return An array of Modules/Documents (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.Module[] queryModulesInBaselineBySQL(java.lang.String sqlQuery, java.lang.String baselineRevision, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Queries for revisions.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param includeInternal Whether internal Polarion commits should be
     * included.
     * @since 3.3.0
     */
    public java.lang.String[] queryRevisionUris(java.lang.String query, java.lang.String sort, boolean includeInternal) throws java.rmi.RemoteException;

    /**
     * Queries for revisions.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The keys of the fields that should be filled in.
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.Revision[] queryRevisions(java.lang.String query, java.lang.String sort, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param resultsLimit Limit the number of results to return.(-1 for
     * unlimited.) 
     * @return An array of Wiki Pages SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryWikiPageUris(java.lang.String query, java.lang.String sort, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages.
     * @param sqlQuery The SQL statement.
     * @return An array of Wiki Pages SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryWikiPageUrisBySQL(java.lang.String sqlQuery) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages in a given Baseline.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The Baseline revision.
     * @param resultsLimit Limit the number of results to return.(-1 for
     * unlimited.) 
     * @return An array of Wiki Pages SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryWikiPageUrisInBaseline(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages in the given Baseline.
     * @param sqlQuery The SQL statement.
     * @param baselineRevision The Baseline revision.
     * @return An array of Wiki Pages SubterraURIs (can be null).
     * @since 3.6.3
     */
    public java.lang.String[] queryWikiPageUrisInBaselineBySQL(java.lang.String sqlQuery, java.lang.String baselineRevision) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields An array of field names to fill in on the returned Wiki
     * Pages (can be null).
     * @param resultsLimit Limit  the maximum number of results to return.
     * (-1 for unlimited.) 
     * @return An array of Wiki Pages (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage[] queryWikiPages(java.lang.String query, java.lang.String sort, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages.
     * @param sqlQuery The SQL statement.
     * @param fields An array of field names to fill in for the returned
     * Wiki Pages. (Can be null.)
     * @return An array of Wiki Pages (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage[] queryWikiPagesBySQL(java.lang.String sqlQuery, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages in the given Baseline.
     * @param query The Lucene query (can be null).
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The Baseline revision.
     * @param fields An array of field names to fill in on the returned Wiki
     * Pages. (Can be null.)
     * @param resultsLimit Limits the number of results to return. (-1 for
     * unlimited.) 
     * @return An array of Wiki Pages (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage[] queryWikiPagesInBaseline(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Searches for Wiki Pages in the given Baseline.
     * @param sqlQuery The SQL statement.
     * @param baselineRevision The Baseline revision.
     * @param fields An array of field names to fill in on the returned Wiki
     * Pages. (Can be null.)
     * @return An array of Wiki Pages (can be null).
     * @since 3.6.3
     */
    public com.polarion.alm.ws.client.types.tracker.WikiPage[] queryWikiPagesInBaselineBySQL(java.lang.String sqlQuery, java.lang.String baselineRevision, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Query the URIs of a Work Item.
     * @param query The Lucene query.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     */
    public java.lang.String[] queryWorkItemUris(java.lang.String query, java.lang.String sort) throws java.rmi.RemoteException;

    /**
     * Query the URIs of Work Items.
     * @param sqlQuery the SQL query.
     * @since 3.6.0
     */
    public java.lang.String[] queryWorkItemUrisBySQL(java.lang.String sqlQuery) throws java.rmi.RemoteException;

    /**
     * Queries for Work Item URIs in a Baseline.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The revision that the Work Items should be
     * returned for.
     * @since 3.6.0
     */
    public java.lang.String[] queryWorkItemUrisInBaseline(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision) throws java.rmi.RemoteException;

    /**
     * Searches for URIs of Work Items in the given Baseline revision.
     * @param sqlQuery The SQL query.
     * @param baselineRevision The Baseline revision that the Work Item should
     * be returned for.
     * @since 3.6.0
     */
    public java.lang.String[] queryWorkItemUrisInBaselineBySQL(java.lang.String sqlQuery, java.lang.String baselineRevision) throws java.rmi.RemoteException;

    /**
     * Queries for Work Item URIs in a baseline with a given limit.
     * @param query the Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The revision that the Work Items should be
     * returned for.
     * @param resultsLimit The maximum number of returned Work Items. (-1
     * for unlimited.) 
     * @since 3.6.0
     */
    public java.lang.String[] queryWorkItemUrisInBaselineLimited(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Query the URIs of a Work Item.
     * @param query the Lucene query.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param resultsLimit The maximum number of returned Work Items. (-1
     * for unlimited.) 
     * @since 3.3.0
     */
    public java.lang.String[] queryWorkItemUrisLimited(java.lang.String query, java.lang.String sort, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The keys for the fields that should be filled in. For
     * nested structures within the lists, use the following syntax to only
     * include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItems(java.lang.String query, java.lang.String sort, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items.
     * @param sqlQuery The SQL query.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures in the lists, use the following syntax to only include
     * a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using following
     * syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsBySQL(java.lang.String sqlQuery, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items in a given Baseline.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The revision that the Work Items should be
     * returned for.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures in the lists, use the following syntax to only include
     * a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsInBaseline(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Searches for Work Items in a given Baseline revision.
     * @param sqlQuery The SQL query.
     * @param baselineRevision The Baseline revision in that the Work Items
     * should be returned for.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures in the lists, use the following syntax to only include
     * a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsInBaselineBySQL(java.lang.String sqlQuery, java.lang.String baselineRevision, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items in a Baseline with a given limit.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param baselineRevision The revision that the Work Items should be
     * returned for.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures in the lists, use the following syntax to only include
     * a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @param resultsLimit The maximum number of returned Work Items. (-1
     * for unlimited.) 
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsInBaselineLimited(java.lang.String query, java.lang.String sort, java.lang.String baselineRevision, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items. The search is done in the current state
     * of the Work Items, but the Work Items
     * are returned in the state of the given revision. Work Items that were
     * deleted since the revision are not returned.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param revision The revision that the Work Items should be returned
     * to.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures within the lists, use the following syntax to only
     * include a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax:  customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @since 3.4.2
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsInRevision(java.lang.String query, java.lang.String sort, java.lang.String revision, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items. The search is done in current state
     * of the Work Items, but the Work Items
     * are returned in the state they are in for the given revision. Work
     * Items that were deleted since the revision are not returned.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param revision The revision that the Work Items should be returned
     * for.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures in the lists, use the following syntax to only include
     * a subset of fields: myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @param resultsLimit maximal returned number of workitems (-1 means
     * no limit)
     * @since 3.4.2
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsInRevisionLimited(java.lang.String query, java.lang.String sort, java.lang.String revision, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Queries for Work Items.
     * @param query The Lucene query to be used.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The keys of the fields that should be filled in. For
     * nested structures within the lists, use the following syntax to only
     * include a subset of fields:  myList.LIST.key (e.g. linkedWorkItems.LIST.role).
     * For custom fields, specify which fields to be filled in using the
     * following syntax: customFields.CUSTOM_FIELD_ID (e.g. customFields.risk).
     * @param resultsLimit The maximum number of returned Work Items. (-1
     * for unlimited.) 
     * @since 3.3.0
     */
    public com.polarion.alm.ws.client.types.tracker.WorkItem[] queryWorkItemsLimited(java.lang.String query, java.lang.String sort, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Removes an approving user.
     * @param workitemURI The URI of the Work Item to remove the approvee
     * from.
     * @param approveeId The Id of the approving user to remove.
     */
    public void removeApprovee(java.lang.String workitemURI, java.lang.String approveeId) throws java.rmi.RemoteException;

    /**
     * Removes an assignee.
     * @param workitemURI The URI of the Work Item to remove the assignee
     * from.
     * @param assigneeId the id of the user to add as an assignee.
     */
    public boolean removeAssignee(java.lang.String workitemURI, java.lang.String assigneeId) throws java.rmi.RemoteException;

    /**
     * Removes a Category.
     * @param workitemURI The URI of the Work Item to remove the Category
     * from.
     * @param categoryId The Id of the Category to Remove.
     */
    public boolean removeCategory(java.lang.String workitemURI, java.lang.String categoryId) throws java.rmi.RemoteException;

    /**
     * Removes a revision from an external repository.
     * @param workitemURI The URI of the Work Item to remove the linked revision
     * from.
     * @param repositoryName The Id of the external repository.
     * @param revisionId The Id of the revision to remove.
     * @since 3.5.1
     */
    public boolean removeExternalLinkedRevision(java.lang.String workitemURI, java.lang.String repositoryName, java.lang.String revisionId) throws java.rmi.RemoteException;

    /**
     * Removes an external linked item.
     * @param workitemURI The URI of the Work Item to remove the linked item
     * from.
     * @param linkedExternalWorkitemURI The URI of the linked item to remove.
     * @param role The role of the linked item to remove.
     * @since 3.5.0
     */
    public boolean removeExternallyLinkedItem(java.lang.String workitemURI, java.lang.String linkedExternalWorkitemURI, com.polarion.alm.ws.client.types.tracker.EnumOptionId role) throws java.rmi.RemoteException;

    /**
     * Removes a hyperlink.
     * @param workitemURI The URI of the Work Item to remove the hyperlink
     * from.
     * @param url The url of the hyperlink to remove.
     */
    public boolean removeHyperlink(java.lang.String workitemURI, java.lang.String url) throws java.rmi.RemoteException;

    /**
     * Removes a linked item.
     * @param workitemURI The URI of the Work Item to remove the linked item
     * from.
     * @param linkedItemURI The URI of the linked item to remove.
     * @param role The role of the linked item to remove.
     */
    public boolean removeLinkedItem(java.lang.String workitemURI, java.lang.String linkedItemURI, com.polarion.alm.ws.client.types.tracker.EnumOptionId role) throws java.rmi.RemoteException;

    /**
     * Removes a revision.
     * @param workitemURI The URI of the Work Item to remove the linked revision
     * from.
     * @param revisionId The Id of the revision to remove.
     */
    public boolean removeLinkedRevision(java.lang.String workitemURI, java.lang.String revisionId) throws java.rmi.RemoteException;

    /**
     * Removes a planing constraint.
     * @param workitemURI The URI of the Work Item to remove the planning
     * constraint from.
     * @param date The date of the planning constraint to remove.
     * @param constraint The Type of constraint to remove.
     */
    public boolean removePlaningConstraint(java.lang.String workitemURI, java.util.Calendar date, com.polarion.alm.ws.client.types.tracker.EnumOptionId constraint) throws java.rmi.RemoteException;

    /**
     * Resets the workflow for the specified object.
     * Performs an initial action if it exists and sets the initial status.
     * @param workflowObjectURI The URI of the WorkflowObject (should not
     * be {@code null}).
     * @throws IllegalArgumentException if the parameter is {@code null}.
     * @since 3.8.1
     */
    public void resetWorkflow(java.lang.String workflowObjectURI) throws java.rmi.RemoteException;

    /**
     * Creates a new Document based on an existing Document.
     * @param sourceURI The URI of the source Document. (Not null.)
     * @param targetProjectId The target Project Id. (Not null.)
     * @param targetLocation The document's Space location with one component
     * or null for the default space. (Can be null.)
     * @param targetName The target Document's name. (Not null.)
     * @param targetTitle The target Document's title. (Can be null.)
     * @param updateTitleInDocument if true then the first title found in
     * the document will be changed to the targetTitle value. (If permissions
     * allow it).
     * @param linkRole The role of links going from a reused Work Item to
     * its source Work Item or null to not create links unless the
     * 	derivedFields are specified. If this is the case, the links will
     * be created with the default role.  (Can be null.)
     * @param derivedFields The fields that are derived from the source Document.
     * (See updateDerivedModule.) (Can be null.)
     * @return The URI of the created Document.
     * @since 3.8.2
     */
    public java.lang.String reuseDocument(java.lang.String sourceURI, java.lang.String targetProjectId, java.lang.String targetLocation, java.lang.String targetName, java.lang.String targetTitle, boolean updateTitleInDocument, com.polarion.alm.ws.client.types.tracker.EnumOptionId linkRole, java.lang.String[] derivedFields) throws java.rmi.RemoteException;

    /**
     * Creates new Module/Document based on the existing Module/Document.
     * @param sourceURI The URI of the source Module/Document.
     * @param targetProjectId The target project Id.
     * @param targetLocation ignored
     * @param targetName The target Module/Document name.
     * @param linkRole The role of links going from a reused Work Item to
     * a source Work Item or null to not create links unless
     * 	the derivedFields are specified. (If so, the links will be created
     * with the default role.) 
     * @param fields ignored
     * @param exceptFields ignored
     * @param derivedFields The fields that are derived from the source Module/Document
     * (see updateDerivedModule).
     * @return The URI of the created Module/Document.
     * @since 3.4.1
     */
    public java.lang.String reuseModule(java.lang.String sourceURI, java.lang.String targetProjectId, java.lang.String targetLocation, java.lang.String targetName, com.polarion.alm.ws.client.types.tracker.EnumOptionId linkRole, java.lang.String[] fields, java.lang.String[] exceptFields, java.lang.String[] derivedFields) throws java.rmi.RemoteException;

    /**
     * Sets the tags of a comment.
     * @param commentURI The URI of the comment.
     * @param tags The tags to set.
     * @since 3.7.1
     */
    public void setCommentTags(java.lang.String commentURI, com.polarion.alm.ws.client.types.tracker.EnumOptionId[] tags) throws java.rmi.RemoteException;

    /**
     * Sets a custom field of a Work Item.
     * @param customField The custom field to set.
     */
    public void setCustomField(com.polarion.alm.ws.client.types.tracker.CustomField customField) throws java.rmi.RemoteException;

    /**
     * Sets a field to null.
     * @param workitemURI The URI of the Work Item to set a fields null for.
     * @param fields The keys of the fields to set null.
     */
    public void setFieldsNull(java.lang.String workitemURI, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Sets the localized description.
     * @param uri The Work Item URI (not null).
     * @param language The language Id (must be defined) or null for the
     * default language.
     * @param description The description (can be null).
     * @since 3.6.1
     */
    public void setLocalizedWorkItemDescription(java.lang.String uri, java.lang.String language, com.polarion.alm.ws.client.types.Text description) throws java.rmi.RemoteException;

    /**
     * Sets the localized title.
     * @param uri The Work Item URI (not null).
     * @param language The language Id (must be defined) or null for the
     * default language.
     * @param title The title (can be null).
     * @since 3.6.1
     */
    public void setLocalizedWorkItemTitle(java.lang.String uri, java.lang.String language, java.lang.String title) throws java.rmi.RemoteException;

    /**
     * Sets the state of the comment to "Resolved". Can only be used
     * for root comments.
     * @param commentURI The URI of the comment.
     * @param resolved The new resolved state.
     * @since 3.7.1
     */
    public void setResolvedComment(java.lang.String commentURI, boolean resolved) throws java.rmi.RemoteException;

    /**
     * Update an existing attachment.
     * @param workitemURI The URI of the Work Item containing the attachment
     * to be updated.
     * @param id The Id of the attachment to be updated.
     * @param fileName The new filename, will be ignored if null is used.
     * @param title The new title, will be ignored if null is used.
     * @param data The new content, will be ignored if null is used.
     * @since 3.3.1
     */
    public void updateAttachment(java.lang.String workitemURI, java.lang.String id, java.lang.String fileName, java.lang.String title, byte[] data) throws java.rmi.RemoteException;

    /**
     * Updates the given Baseline.
     * @param baseline The updated Baseline (not null).
     * @since 3.7.1
     */
    public void updateBaseline(com.polarion.alm.ws.client.types.tracker.Baseline baseline) throws java.rmi.RemoteException;

    /**
     * Updates derived Document to the new revision (Baseline).
     * @param documentURI The derived document.
     * @param revision Null refers to the HEAD revision
     * @param autoSuspect
     * @since 3.5.3
     */
    public void updateDerivedDocument(java.lang.String documentURI, java.lang.String revision, boolean autoSuspect) throws java.rmi.RemoteException;

    /**
     * Updates derived the Module/Document to the new revision (Baseline).
     * @param moduleURI The derived Module/Document.
     * @param revision Null refers to the HEAD revision.
     * @since 3.4.1
     */
    public void updateDerivedModule(java.lang.String moduleURI, java.lang.String revision) throws java.rmi.RemoteException;

    /**
     * Updates a Module/Document.
     * Changes for some fields of a passed Module (like array fields) are
     * ignored when calling this method.
     * @param module updated Module/Document
     * @since 3.4.1
     */
    public void updateModule(com.polarion.alm.ws.client.types.tracker.Module module) throws java.rmi.RemoteException;

    /**
     * Updates the first Title Heading in the Document's content.
     * @param documentURI The URI of the Document. (Not null.)
     * @param title The Document title. (Can be null.)
     * @return The URI of an updated Title Heading or null if no Title Heading
     * in the Document's content was updated.
     * @since 3.8.2
     */
    public java.lang.String updateTitleHeadingInDocument(java.lang.String documentURI, java.lang.String title) throws java.rmi.RemoteException;

    /**
     * Updates a Work Item. The Work Item passed has to contain the
     * valid URI of the Work Item being updated.
     * Fields that are not transmitted will not be set on the target Work
     * Item.
     * Therefore only the changed fields and the URI should be sent to save
     * resources.
     * Please note that some fields in the updated Work Item: assignee, hyperlink,
     * comment, category, id, created, updated,
     * moduleURI, plannedEnd, plannedStart, plannedInURIs, planningConstraints,
     * author, project, externallyLinkedWorkItems, linkedRevisions,
     * linkedRevisionsDerived, linkedOslcResources, attachments, approvals,
     * workRecords, outlineNumber will not be changed.
     * Use other methods to adjust your updated Work Item e.g. createComment,
     * addHyperlink, addAssignee, addLinkedItem, addCategory.
     * @param content The altered content.
     */
    public void updateWorkItem(com.polarion.alm.ws.client.types.tracker.WorkItem content) throws java.rmi.RemoteException;
}
