/**
 * TestManagementWebService.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.polarion.alm.ws.client.testmanagement;

public interface TestManagementWebService extends java.rmi.Remote {

    /**
     * Adds a new Attachment to the specified Test Record. 
     * The created attachment can have a different file name than the one
     * given.
     * @param testRunUri The testRunUri URI of the Test Run that contains
     * the target Test Record.
     * @param index The index of the Test Record in the Test Run.
     * @param fileName The Attachment's file name.
     * @param title The Attachment's title.
     * @param data The Attachment's data.
     * @since 3.7.3
     */
    public void addAttachmentToTestRecord(java.lang.String testRunUri, int index, java.lang.String fileName, java.lang.String title, byte[] data) throws java.rmi.RemoteException;

    /**
     * Adds a new Attachment to the given Test Run or Test Run Template.
     * 
     * @param testRunUri The URI of the target Test Run or Test Run Template.
     * @param fileName The Attachment's file name.
     * @param title The Attachment's title.
     * @param data The Attachment's data.
     * @since 3.7.1
     */
    public void addAttachmentToTestRun(java.lang.String testRunUri, java.lang.String fileName, java.lang.String title, byte[] data) throws java.rmi.RemoteException;

    /**
     * Adds a new Attachment to the specified Test Step. 
     * The created Attachment can have a different file name from the given
     * one.
     * @param testRunUri The testRunUri URI of the Test Run that contains
     * the target Test Step.
     * @param index The index of the Test Record in the Test Run that contains
     * the target Test Step.
     * @param testStepIndex The index of the Test Step in the Test Record.
     * @param fileName The attachment's file name.
     * @param title The attachment's title.
     * @param data The attachment's data.
     * @since 3.7.3
     */
    public void addAttachmentToTestStep(java.lang.String testRunUri, int index, int testStepIndex, java.lang.String fileName, java.lang.String title, byte[] data) throws java.rmi.RemoteException;

    /**
     * Adds a specified Project to the Project Span of the Test Run.
     * @param uri The URI of the Test Run. (Not null.)
     * @param projectId The Project Id of the Project to be added. (Not null.)
     * @since 3.10.1
     */
    public void addProjectToProjectSpan(java.lang.String uri, java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Add a Test Record to a Test Run.
     * @param testRunUri The URI of the Test Run that the Test Record will
     * be added to.
     * @param testCaseUri The URI of the executed Test Case.
     * @param testResultId The Id of the Test Result. Can be {@code null}.
     * @param testComment The comment to be tracked with the Test Record.
     * Can be {@code null}.
     * @param executedByUri The URI of the user to be used as the Author
     * of the Test Record. Can be {@code null}.
     * @param executed date When the Test Case has been executed. Can be
     * {@code null}.
     * @param duration The time it takes to execute the Test Case. A negative
     * value is treated as {@code null}.
     * @param defectUri The URI of the Defect Work Item to be linked from
     * created record. Can be {@code null}. 
     * @since 3.6.0
     */
    public void addTestRecord(java.lang.String testRunUri, java.lang.String testCaseUri, java.lang.String testResultId, com.polarion.alm.ws.client.types.Text testComment, java.lang.String executedByUri, java.util.Calendar executed, float duration, java.lang.String defectUri) throws java.rmi.RemoteException;

    /**
     * Adds the Test Record to the Test Run. If the Test Record to
     * add 
     * has a result but does not have the Test Case revision filled in, the
     * added Test Record will automatically 
     * set the Test Case revision to the current revision of the Test Case.
     * 
     * @param testRunUri The URI of the target Test Run. 
     * @param testRecord The Test Record to add.
     * @since 3.7.0
     */
    public void addTestRecordToTestRun(java.lang.String testRunUri, com.polarion.alm.ws.client.types.testmanagement.TestRecord testRecord) throws java.rmi.RemoteException;

    /**
     * Create or return an existing Summary Defect Work Item of a
     * Test Run.
     * @param testRunUri The URI of the Test Run to update the summary defect
     * for.
     * @param defectTemplateUri The URI of the Defect Work Item template
     * to be used.  The configured template will be used if {@code null}.
     * @return The URI of the created or existing Summary Defect Work Item.
     * @since 3.6.0
     */
    public java.lang.String createSummaryDefect(java.lang.String testRunUri, java.lang.String defectTemplateUri) throws java.rmi.RemoteException;

    /**
     * Create a new Test Run.
     * @param project The Project the Test Run will be created in. 
     * @param id The Id of the Test Run to be created.
     * @param template The template used to create the Test Run.
     * @return The URI of the created Test Run.
     * @since 3.6.0
     */
    public java.lang.String createTestRun(java.lang.String project, java.lang.String id, java.lang.String template) throws java.rmi.RemoteException;

    /**
     * Create a new Test Run.
     * @param project The Project the Test Run will be created in. 
     * @param id The Id of the Test Run to be created in.
     * @param title The title of the Test Run to be created. The template
     * title is used when null.
     * @param template The template used to create the Test Run.
     * @return The URI of the created Test Run.
     * @since 3.10.1
     */
    public java.lang.String createTestRunWithTitle(java.lang.String project, java.lang.String id, java.lang.String title, java.lang.String template) throws java.rmi.RemoteException;

    /**
     * Deletes the Test Record Attachment given by the Test Run, the
     * index of the Test Record and the Attachment's file name.
     * @param testRunUri The testRunUri URI of the Test Run that contains
     * the target Test Record.
     * @param index The index of the Test Record in the Test Run.
     * @param fileName The Attachment's file name.
     * @since 3.7.3
     */
    public void deleteAttachmentFromTestRecord(java.lang.String testRunUri, int index, java.lang.String fileName) throws java.rmi.RemoteException;

    /**
     * Deletes the Test Step Attachment given by the Test Run, the
     * index of Test Records, the index of Test Steps and the Attachment's
     * file name.
     * @param testRunUri The testRunUri URI of the Test Run that contains
     * the target Test Record.
     * @param index The index of the Test Record in the Test Run.
     * @param testStepIndex The index of the Test Step in the Test Record.
     * @param fileName The attachment's file name.
     * @since 3.7.3
     */
    public void deleteAttachmentFromTestStep(java.lang.String testRunUri, int index, int testStepIndex, java.lang.String fileName) throws java.rmi.RemoteException;

    /**
     * Deletes the Test Run Attachment matching the Test Run and Attachment's
     * file name.
     * This Method is applicable for Test Run Templates. 
     * @param testRunUri The URI of the Test Run or Test Run Template containing
     * the target Attachment. (Not null.)
     * @param fileName The file name of Attachment to delete.
     * @since 3.7.1
     */
    public void deleteTestRunAttachment(java.lang.String testRunUri, java.lang.String fileName) throws java.rmi.RemoteException;

    /**
     * Executes Test Cases given by the Test Records within a specified
     * Test Run. This method differs from others within this web service
     * because it can execute multiple Test Cases in a single call.
     * It can also create a defect if a Test Case fails. (If configured to
     * do so on the Polarion server.)  
     * It replaces having to call multiple web services like addTestRecord(...)
     * or updateTestRecord(...) and the manual creation of a defect.
     * Test parameters in the supplied Test Records override any parameters
     * contained within the original planned test records and the Test Run
     * itself.
     * If a required parameter is supplied with an empty value, the Method
     * will fail.
     * It is not necessary to fill in all the parameters, only those that
     * do not have a value set in the Test Run or planned Test Case, 
     * or those that should be changed.
     * @param testRunUri The URI of the Test Run. (Not null.)
     * @param testRecords An array containing Test Records for executed Test
     * Cases. Submitted Test Records are automatically updated. For example,
     * when a Test Case is planned, paused or created. (Not null.)  
     * @since 3.10.3
     */
    public void executeTest(java.lang.String testRunUri, com.polarion.alm.ws.client.types.testmanagement.TestRecord[] testRecords) throws java.rmi.RemoteException;

    /**
     * Gets all custom field keys defined for a Test Run.
     * @param projectID The Id of the Project. (If null, the Global context
     * is used.)
     * @since 3.10.3
     */
    public java.lang.String[] getDefinedTestRunCustomFieldKeys(java.lang.String projectID) throws java.rmi.RemoteException;

    /**
     * Gets a custom field definition for a Test Run.
     * @param projectID The ID of the Project. (If null, the Global context
     * is used.)
     * @param key The custom field's key. (Not null.)
     * @since 3.10.3
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType getDefinedTestRunCustomFieldType(java.lang.String projectID, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets all custom field definitions for a Test Run.
     * @param projectID The Id of the Project. (If null, the Global context
     * is used.)
     * @since 3.10.3
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType[] getDefinedTestRunCustomFieldTypes(java.lang.String projectID) throws java.rmi.RemoteException;

    /**
     * Returns an array of test parameter names used in the Test Case.
     * @param testCaseUri The URI of the Test Case. (Not null).
     * @since 3.17.0
     */
    public java.lang.String[] getTestCaseParameterNames(java.lang.String testCaseUri) throws java.rmi.RemoteException;

    /**
     * Returns the Test Records of a particular Test Case in a Test
     * Run.
     * @param testRunUri The URI of the Test Run. (Not null).  		
     * @param testCaseUri The URI of the Test Case (Mot null).
     * @since 3.17.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRecord[] getTestCaseRecords(java.lang.String testRunUri, java.lang.String testCaseUri) throws java.rmi.RemoteException;

    /**
     * Returns the Project level test parameter library.
     * @param projectId The Id of the Project to get the test parameter library
     * for. (Not null.)
     * @since 3.17.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.ParametersLibrary getTestParametersLibrary(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Returns an Attachment of a given Test Run or Test Run Template.
     * 
     * @param testRunUri The URI of the target Test Run or Test Run Template.
     * @return the attachment
     * @since 3.7.1
     */
    public com.polarion.alm.ws.client.types.tracker.TestRunAttachment getTestRunAttachment(java.lang.String testRunUri, java.lang.String filename) throws java.rmi.RemoteException;

    /**
     * Returns the Attachments of a given Test Run or Test Run Template.
     * 
     * @param testRunUri The URI of the target Test Run or Test Run Template.
     * @return attachments
     * @since 3.7.1
     */
    public com.polarion.alm.ws.client.types.tracker.TestRunAttachment[] getTestRunAttachments(java.lang.String testRunUri) throws java.rmi.RemoteException;

    /**
     * Returns a specific Test Run.
     * @param project The Id of the Project that contains the Test Run to
     * load.
     * @param id The Id of the Test Run to load.
     * @return the Test Run.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun getTestRunById(java.lang.String project, java.lang.String id) throws java.rmi.RemoteException;

    /**
     * Returns a specific Test Run that only contains values for the
     * specified list of fields.
     * @param project The Id of the Project that contains the Test Run to
     * load. (Not null.)
     * @param id The Id of the Test Run to load. (Not null.)
     * @param keys The keys of Test Run properties that should be copied
     * from the Test Run. (Not null.)
     * @return The Test Run. (Not null.)
     * @since 3.17.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun getTestRunByIdWithFields(java.lang.String project, java.lang.String id, java.lang.String[] keys) throws java.rmi.RemoteException;

    /**
     * Returns a specific Test Run.
     * @param uri The URI of the Test Run to load.
     * @return The Test Run.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun getTestRunByUri(java.lang.String uri) throws java.rmi.RemoteException;

    /**
     * Returns a specific Test Run that only contains values for the
     * specified list of fields.
     * @param uri The URI of the Test Run to load. (Not null.)
     * @param keys The keys of the Test Run properties that should be copied
     * from the Test Run. (Not null.)
     * @return the Test Run. (not null)
     * @since 3.17.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun getTestRunByUriWithFields(java.lang.String uri, java.lang.String[] keys) throws java.rmi.RemoteException;

    /**
     * Gets the custom field definitions for a specific Test Run.
     * @param testRunURI The URI of the Test Run. (Not null.)
     * @param key The custom field's key. (Not null.)
     * @since 3.10.3
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType getTestRunCustomFieldType(java.lang.String testRunURI, java.lang.String key) throws java.rmi.RemoteException;

    /**
     * Gets all custom field definitions for a specific Test Run.
     * @param testRunURI The URI of the Test Run. (Not null.)
     * @since 3.10.3
     */
    public com.polarion.alm.ws.client.types.tracker.CustomFieldType[] getTestRunCustomFieldTypes(java.lang.String testRunURI) throws java.rmi.RemoteException;

    /**
     * Gets the Test Steps of the Work Item with the URI.
     * @param uri The URI of the Work Item to get.
     * @return The Test Steps of the Work Item with the given URI.
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestSteps getTestSteps(java.lang.String uri) throws java.rmi.RemoteException;

    /**
     * Gets the default Test Steps custom field configuration.
     * 			
     * @param projectId The Id of the Project containing the Test Step configuration.
     * 			
     * @return An EnumOption array containing the configuration for each
     * Test Step column.
     * 			
     * @since 3.7.0
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getTestStepsConfiguration(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Gets the Test Steps custom field configuration for a specific
     * Work Item type.
     * 			
     * @param projectId The Id of the Project containing the Test Step configuration.
     * 			
     * @param wiType The type of the Work Item.
     * 			
     * @return An EnumOption array containing the configuration for each
     * Test Step column.
     * 			
     * @since 3.23.10
     */
    public com.polarion.alm.ws.client.types.tracker.EnumOption[] getTestStepsConfigurationByWorkItemType(java.lang.String projectId, java.lang.String wiType) throws java.rmi.RemoteException;

    /**
     * Get the test management configuration for a specific Project.
     * @param projectId The Id of the Project to get the test configuration
     * for.
     * @return The configuration.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestsConfiguration getTestsConfiguration(java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Returns the Wiki Page content of Test Run or Test Run Template.
     * 
     * @param testRunUri The URI of the target Test Run or Test Run Template.
     * @return The Wiki Page content of Test Run or Test Run Template.  
     * @since 3.7.1
     */
    public com.polarion.alm.ws.client.types.Text getWikiContentForTestRun(java.lang.String testRunUri) throws java.rmi.RemoteException;

    /**
     * Removes the specified Project from the Project Span of the
     * Test Run.
     * @param uri The URI of the Test Run. (Not null.)
     * @param projectId The Project Id of the Project to be removed. (Not
     * null).
     * @since 3.10.1
     */
    public void removeProjectFromProjectSpan(java.lang.String uri, java.lang.String projectId) throws java.rmi.RemoteException;

    /**
     * Search for Test Records.
     * @param query The query used to find Test Records.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param limit The maximum number of records to be returned. (-1 for
     * unlimited.) 
     * @return the found test records.
     * @since 3.6.0
     * @deprecated since 3.8.1 with no direct replacement.
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRecord[] searchTestRecords(java.lang.String query, java.lang.String sort, int limit) throws java.rmi.RemoteException;

    /**
     * Search Test Run templates.
     * @param query The query used to find test run templates.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @return The found Test Run templates.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunTemplates(java.lang.String query, java.lang.String sort) throws java.rmi.RemoteException;

    /**
     * Search Test Run templates.
     * @param query The query used to find Test Run templates.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param resultsLimit The maximum number of records to be returned.
     * (-1 for unlimited.) 
     * @return The found Test Run templates.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunTemplatesLimited(java.lang.String query, java.lang.String sort, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Search Test Run templates.
     * @param query The query used to find Test Run templates.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The Test Run fields that should be initialized. All
     * other fields will be {@code null}.
     * @return The found Test Run templates.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunTemplatesWithFields(java.lang.String query, java.lang.String sort, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Search Test Run templates.
     * @param query The query used to find Test Run templates.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The Test Run fields that should be initialized. All
     * other fields will be {@code null}.
     * @param resultsLimit The maximum number of records to be returned.
     * (-1 for unlimited.) 
     * @return The found Test Run templates.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunTemplatesWithFieldsLimited(java.lang.String query, java.lang.String sort, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Search Test Runs.
     * @param query The query used to find Test Runs.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @return The found Test Runs.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRuns(java.lang.String query, java.lang.String sort) throws java.rmi.RemoteException;

    /**
     * Search test runs.
     * @param query The query used to find Test Runs.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param resultsLimit The maximum number of records to be returned.
     * (-1 for unlimited.) 
     * @return The found test runs.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunsLimited(java.lang.String query, java.lang.String sort, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Search Test Runs.
     * @param query The query used to find Test Runs.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The Test Run fields that should be initialized. All
     * other fields will be {@code null}.
     * @return The found Test Runs.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunsWithFields(java.lang.String query, java.lang.String sort, java.lang.String[] fields) throws java.rmi.RemoteException;

    /**
     * Search Test Runs.
     * @param query The query used to find Test Runs.
     * @param sort The format is same as for {@link com.polarion.platform.persistence.IIndexSearch#sort(String)}.
     * @param fields The Test Run fields that should be initialized. All
     * other fields will be {@code null}.
     * @param resultsLimit The maximum number of records to be returned.
     * (-1 for unlimited.) 
     * @return The found Test Runs.
     * @since 3.6.0
     */
    public com.polarion.alm.ws.client.types.testmanagement.TestRun[] searchTestRunsWithFieldsLimited(java.lang.String query, java.lang.String sort, java.lang.String[] fields, int resultsLimit) throws java.rmi.RemoteException;

    /**
     * Adds the Test Steps to the Work Item with the given URI. (The
     * add operation).
     * 			If the Work Item already has Test Steps, they will be completely
     * replaced. (The update operation).
     * 			If the testSteps parameter is {@code null}, the content of the
     * Test Steps field will be emptied. (The delete
     * 			operation).
     * 			
     * @param workItemURI The SubterraURI of the item to set the Work Item.
     * 			
     * @param testSteps An array containing an entry for each step.
     * 			
     * @since 3.7.0
     */
    public void setTestSteps(java.lang.String workItemURI, com.polarion.alm.ws.client.types.testmanagement.TestStep[] testSteps) throws java.rmi.RemoteException;

    /**
     * Create or update the Summary Defect Work Item of a Test Run.
     * @param testRunUri The URI of the Test Run to update the Summary Defect
     * for.
     * @param source The source of the Summary Defect, used to generate the
     * Description content.
     * @param totalFailures The amount of total failures in the Test Run.
     * (Used to generate the Description content.)
     * @param totalErrors The total number of errors in the Test Run. (Used
     * to generate the Description content.)
     * @param totalTests The total number of tests in the Test Run. (Used
     * to generate the Description content.)
     * @param defectTemplateUri The URI of the Defect Work Item template
     * to be used. The configured template will be used if {@code null}.
     * @return The URI of the created Summary Defect Work Item.
     * @since 3.6.0
     */
    public java.lang.String updateSummaryDefect(java.lang.String testRunUri, java.lang.String source, int totalFailures, int totalErrors, int totalTests, java.lang.String defectTemplateUri) throws java.rmi.RemoteException;

    /**
     * Update a Test Record.
     * @param testRunUri The URI of the Test Run that the Test Record will
     * be updated for.
     * @param index The index of the Test Record in the list of all executed
     * Test Run Test Records.
     * @param testResultId The Id of the test result. Can be {@code null}.
     * @param testComment The comment to be tracked with the Test Record.
     * Can be {@code null}.
     * @param executedByUri The URI of the user to be used as the Author
     * of the Test Record. Can be {@code null}.
     * @param executed date When the Test Case was executed. Can be {@code
     * null}.
     * @param duration The time it takes to execute the Test Case. A negative
     * value is treated as {@code null}.
     * @param defectUri The URI of the Defect Work Item to be linked from
     * the created record. Can be {@code null}. 
     * @since 3.6.0
     */
    public void updateTestRecord(java.lang.String testRunUri, int index, java.lang.String testResultId, com.polarion.alm.ws.client.types.Text testComment, java.lang.String executedByUri, java.util.Calendar executed, float duration, java.lang.String defectUri) throws java.rmi.RemoteException;

    /**
     * Updates or removes the Test Record at a given index in the
     * Test Run. 
     * Test parameters should not be entered in the supplied Test Record
     * because they are ignored by this method. (This may change in the future.)
     * 
     * @param testRunUri The URI of the target Test Run. (Not null). 
     * @param index The index of the Test Record in the list of all Test
     * Run Test Records.
     * @param testRecord The new Test Record content, or null to remove the
     * Test Record.
     * @since 3.7.0
     */
    public void updateTestRecordAtIndex(java.lang.String testRunUri, int index, com.polarion.alm.ws.client.types.testmanagement.TestRecord testRecord) throws java.rmi.RemoteException;

    /**
     * Update a Test Run.
     * @param content The new Test Run content. The URI of the content must
     * be set, otherwise the call will fail.
     * @since 3.6.0
     */
    public void updateTestRun(com.polarion.alm.ws.client.types.testmanagement.TestRun content) throws java.rmi.RemoteException;

    /**
     * Updates the Test Run Attachment matching the Test Run and Attachment's
     * file name.
     * This Method is applicable for Test Run Templates.
     * @param testRunUri The URI of the Test Run or Test Run Template containing
     * the target Attachment.
     * @param fileName The file name of the Attachment to update.
     * @param title The new attachment's title. (If null, the attachment's
     * title is not updated.)
     * @param data The new attachment's data. (If null, the attachment's
     * data is not updated.)
     * @since 3.7.1
     */
    public void updateTestRunAttachment(java.lang.String testRunUri, java.lang.String fileName, java.lang.String title, byte[] data) throws java.rmi.RemoteException;

    /**
     * Updates the Wiki Page content of a given Test Run or Test Run
     * Template. 
     * @param testRunUri The URI of the Test Run or Test Run Template.
     * @param content The new Wiki Page content of the Test Run or Test Run
     * Template.  
     * @since 3.7.1
     */
    public void updateWikiContentForTestRun(java.lang.String testRunUri, com.polarion.alm.ws.client.types.Text content) throws java.rmi.RemoteException;
}
