/**
 * SessionWebService.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.polarion.alm.ws.client.session;

public interface SessionWebService extends java.rmi.Remote {

    /**
     * Starts a explicit transaction for the current session.
     * Usually transactions are started and committed for each call to the
     * webservice, but if a transaction has been started explicitly it also
     * has to be terminated using endTransaction.
     */
    public void beginTransaction() throws java.rmi.RemoteException;

    /**
     * Terminates the current session.
     */
    public void endSession() throws java.rmi.RemoteException;

    /**
     * Ends the explicit transaction of the current session by either
     * commit or rollback.
     * @param rollback if true the transaction is rolled back otherwise it
     * is commited.
     */
    public void endTransaction(boolean rollback) throws java.rmi.RemoteException;

    /**
     * Checks if a user is logged in for the current session.
     */
    public boolean hasSubject() throws java.rmi.RemoteException;

    /**
     * Logs a user in for the current session.
     * @param userName the name of the user to log-in.
     * @param password the password of the user to log-in.
     */
    public void logIn(java.lang.String userName, java.lang.String password) throws java.rmi.RemoteException;

    /**
     * This method works for both Teamcenter Security Services SSO
     * and Personal Access Tokens (since Polarion 3.22.1).
     * Possible (case insensitive) values for the mechanism parameters: TcSS
     * and AccessToken.
     * 
     * This will NOT work for the other SSO methods supported by Polarion.
     * (Kerberos, SAML, or OAuth2.)
     * For SAML, OAuth2 (or deprecated Kerberos), you should use the SessionWebService.logIn(username,
     * password) method (LDAP configuration should be enabled for web services)
     * or use an access token.
     * 
     * @param mechanism the mechanism that the client requests for authentication.
     * If the TcSS mechanism is used, the server must be configured for TcSS.
     * (Otherwise, the login with this mechanism will be rejected.) AccessToken
     * is always accepted.
     * @param username the name of the user to login. Required for TcSS.
     * null for AccessToken
     * @param token the token of the user to login.
     * @since 3.17.0
     */
    public void logInWithToken(java.lang.String mechanism, java.lang.String username, java.lang.String token) throws java.rmi.RemoteException;

    /**
     * Check if there is a explicit transaction (started with beginTransaction)
     * for the current session.
     */
    public boolean transactionExists() throws java.rmi.RemoteException;
}
