/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class ServiceFactory
extends javax.xml.rpc.ServiceFactory
implements ObjectFactory {
    protected static Log log = LogFactory.getLog((String)ServiceFactory.class.getName());
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    public static final String SERVICE_IMPLEMENTATION_NAME_PROPERTY = "serviceImplementationName";
    private static final String SERVICE_IMPLEMENTATION_SUFFIX = "Locator";
    private static EngineConfiguration _defaultEngineConfig = null;
    private static ThreadLocal<EngineConfiguration> threadDefaultConfig = new ThreadLocal();

    public static void setThreadDefaultConfig(EngineConfiguration config) {
        threadDefaultConfig.set(config);
    }

    private static EngineConfiguration getDefaultEngineConfig() {
        if (_defaultEngineConfig == null) {
            _defaultEngineConfig = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        }
        return _defaultEngineConfig;
    }

    public static Service getService(Map<String, Object> environment) {
        Service service = null;
        InitialContext context = null;
        EngineConfiguration configProvider = (EngineConfiguration)environment.get("engineConfig");
        if (configProvider == null) {
            configProvider = threadDefaultConfig.get();
        }
        if (configProvider == null) {
            configProvider = ServiceFactory.getDefaultEngineConfig();
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (context != null) {
            String name = (String)environment.get("jndiName");
            if (name != null) {
                String upperCaseName = name.toUpperCase();
                if (upperCaseName.contains("LDAP") || upperCaseName.contains("RMI") || upperCaseName.contains("JMS") || upperCaseName.contains("JMX") || upperCaseName.contains("JRMP") || upperCaseName.contains("JAVA") || upperCaseName.contains("DNS") || upperCaseName.contains("IIOP") || upperCaseName.contains("CORBANAME")) {
                    log.warn((Object)("returning null, jndiName received by ServiceFactory.getService() is not supported by this method: " + name));
                    return null;
                }
            } else {
                name = "axisServiceName";
            }
            try {
                service = (Service)context.lookup(name);
            }
            catch (NamingException e) {
                service = new Service(configProvider);
                try {
                    context.bind(name, (Object)service);
                }
                catch (NamingException e1) {
                    return null;
                }
            }
        } else {
            service = new Service(configProvider);
        }
        return service;
    }

    @Override
    public Object getObjectInstance(Object refObject, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object instance = null;
        if (refObject instanceof Reference) {
            Reference ref = (Reference)refObject;
            RefAddr addr = ref.get(SERVICE_CLASSNAME);
            Object obj = null;
            if (addr != null && (obj = addr.getContent()) instanceof String) {
                instance = ClassUtils.forName((String)((String)obj)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                addr = ref.get(WSDL_LOCATION);
                if (addr != null && (obj = addr.getContent()) instanceof String) {
                    URL wsdlLocation = new URL((String)obj);
                    addr = ref.get(SERVICE_NAMESPACE);
                    if (addr != null && (obj = addr.getContent()) instanceof String) {
                        String namespace = (String)obj;
                        addr = ref.get(SERVICE_LOCAL_PART);
                        if (addr != null && (obj = addr.getContent()) instanceof String) {
                            String localPart = (String)obj;
                            QName serviceName = new QName(namespace, localPart);
                            Class[] formalArgs = new Class[]{URL.class, QName.class};
                            Object[] actualArgs = new Object[]{wsdlLocation, serviceName};
                            Constructor ctor = Service.class.getDeclaredConstructor(formalArgs);
                            instance = ctor.newInstance(actualArgs);
                        }
                    }
                }
            }
            addr = ref.get(MAINTAIN_SESSION);
            if (addr != null && instance instanceof Service) {
                ((Service)instance).setMaintainSession(true);
            }
        }
        return instance;
    }

    public javax.xml.rpc.Service createService(URL wsdlDocumentLocation, QName serviceName) throws ServiceException {
        return new Service(wsdlDocumentLocation, serviceName);
    }

    public javax.xml.rpc.Service createService(QName serviceName) throws ServiceException {
        return new Service(serviceName);
    }

    public javax.xml.rpc.Service loadService(Class serviceInterface) throws ServiceException {
        if (serviceInterface == null) {
            throw new IllegalArgumentException(Messages.getMessage((String)"serviceFactoryIllegalServiceInterface"));
        }
        if (!javax.xml.rpc.Service.class.isAssignableFrom(serviceInterface)) {
            throw new ServiceException(Messages.getMessage((String)"serviceFactoryServiceInterfaceRequirement", (String)serviceInterface.getName()));
        }
        String serviceImplementationName = String.valueOf(serviceInterface.getName()) + SERVICE_IMPLEMENTATION_SUFFIX;
        Service service = this.createService(serviceImplementationName);
        return service;
    }

    public javax.xml.rpc.Service loadService(URL wsdlDocumentLocation, Class serviceInterface, Properties properties) throws ServiceException {
        if (serviceInterface == null) {
            throw new IllegalArgumentException(Messages.getMessage((String)"serviceFactoryIllegalServiceInterface"));
        }
        if (!javax.xml.rpc.Service.class.isAssignableFrom(serviceInterface)) {
            throw new ServiceException(Messages.getMessage((String)"serviceFactoryServiceInterfaceRequirement", (String)serviceInterface.getName()));
        }
        String serviceImplementationName = String.valueOf(serviceInterface.getName()) + SERVICE_IMPLEMENTATION_SUFFIX;
        Service service = this.createService(serviceImplementationName);
        return service;
    }

    public javax.xml.rpc.Service loadService(URL wsdlDocumentLocation, QName serviceName, Properties properties) throws ServiceException {
        String serviceImplementationName = properties.getProperty(SERVICE_IMPLEMENTATION_NAME_PROPERTY);
        Service service = this.createService(serviceImplementationName);
        if (service.getServiceName().equals(serviceName)) {
            return service;
        }
        throw new ServiceException(Messages.getMessage((String)"serviceFactoryServiceImplementationNotFound", (String)serviceImplementationName));
    }

    private Service createService(String serviceImplementationName) throws ServiceException {
        if (serviceImplementationName == null) {
            throw new IllegalArgumentException(Messages.getMessage((String)"serviceFactoryInvalidServiceName"));
        }
        try {
            Class<?> serviceImplementationClass = Thread.currentThread().getContextClassLoader().loadClass(serviceImplementationName);
            if (!Service.class.isAssignableFrom(serviceImplementationClass)) {
                throw new ServiceException(Messages.getMessage((String)"serviceFactoryServiceImplementationRequirement", (String)serviceImplementationName));
            }
            Service service = (Service)serviceImplementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (service.getServiceName() != null) {
                return service;
            }
            throw new ServiceException(Messages.getMessage((String)"serviceFactoryInvalidServiceName"));
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

