/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.widget;

import com.polarion.alm.shared.api.model.ModelObjectReference;
import com.polarion.alm.shared.api.model.eo.EnumOption;
import com.polarion.alm.shared.api.model.fields.DurationValue;
import com.polarion.alm.shared.api.model.rp.parameter.CompositeParameter;
import com.polarion.alm.shared.api.model.rp.parameter.EnumParameter;
import com.polarion.alm.shared.api.model.rp.parameter.FieldsParameter;
import com.polarion.alm.shared.api.model.rp.parameter.ObjectSelectorParameter;
import com.polarion.alm.shared.api.model.rp.parameter.RichPageParameter;
import com.polarion.alm.shared.api.model.rp.parameter.StringParameter;
import com.polarion.alm.shared.api.model.rp.widget.PropertiesSidebarConfiguredContainer;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidgetRenderingContext;
import com.polarion.alm.shared.api.model.wi.WorkItem;
import com.polarion.alm.shared.api.model.wi.WorkItemRenderer;
import com.polarion.alm.shared.api.model.wi.linked.LinkedWorkItem;
import com.polarion.alm.shared.api.model.wr.WorkRecord;
import com.polarion.alm.shared.api.utils.html.HtmlContentBuilder;
import com.polarion.alm.shared.api.utils.html.HtmlFragmentBuilder;
import com.polarion.alm.shared.api.utils.html.HtmlTagBuilder;
import com.polarion.alm.shared.api.utils.html.RichTextRenderTarget;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkRecordReportWidgetRenderer {
    @NotNull
    private final RichPageWidgetRenderingContext context;
    private final WorkItem userStory;
    private PropertiesSidebarConfiguredContainer sidebarContainer;
    private EnumOption linkRole;
    @Nullable
    private String tableStyle;
    @Nullable
    private String headerCellStyle;
    @Nullable
    private String rowCellStyle;
    private String warningMessage;
    private boolean hasPermission;
    private List<String> sidebarFieldIds;

    public WorkRecordReportWidgetRenderer(@NotNull RichPageWidgetRenderingContext context) {
        this.context = context;
        this.userStory = this.getUserStory();
        if (this.userStory == null) {
            return;
        }
        this.hasPermission = this.userStory.fields().timeSpent().can().modify();
        this.linkRole = this.getRequiredEnumParameterValue("linkRole");
        this.sidebarFieldIds = StreamSupport.stream(((FieldsParameter)context.parameter("wiPropertiesSidebarFields")).fields().spliterator(), false).map(field -> field.id()).collect(Collectors.toList());
        CompositeParameter advanced = (CompositeParameter)context.parameter("advanced");
        this.tableStyle = this.getStringParameterValue(advanced, "tableStyle");
        this.headerCellStyle = this.getStringParameterValue(advanced, "tableHeaderCellStyle");
        this.rowCellStyle = this.getStringParameterValue(advanced, "tableRowCellStyle");
    }

    private void reportWarning(@NotNull String message) {
        this.warningMessage = message;
    }

    @Nullable
    private WorkItem getUserStory() {
        ObjectSelectorParameter parameter = (ObjectSelectorParameter)this.context.parameter("userStory");
        WorkItem workItem = (WorkItem)parameter.value();
        if (workItem == null) {
            this.reportWarning("User story is undefined.");
            return null;
        }
        return workItem;
    }

    @NotNull
    public String render() {
        HtmlFragmentBuilder builder = this.context.createHtmlFragmentBuilder();
        if (this.warningMessage != null) {
            return this.context.renderWarning(this.warningMessage);
        }
        HtmlTagBuilder table = this.hasPropertiesSidebar() ? this.getTableWithSidebar(builder) : (HtmlTagBuilder)builder.tag().table();
        table.attributes().className("polarion-rpw-table-content").style(this.tableStyle);
        this.appendTableHeaderRow(table, this.userStory);
        DurationValue total = this.appendWorkItemRows(table, this.userStory);
        this.appendTotalRow(table, total);
        return builder.toString();
    }

    @NotNull
    private HtmlTagBuilder getTableWithSidebar(@NotNull HtmlFragmentBuilder builder) {
        this.sidebarContainer = this.context.propertiesSidebarConfiguration().fieldIds(this.sidebarFieldIds).addTo(builder);
        return (HtmlTagBuilder)this.sidebarContainer.htmlTagBuilder().append().tag().table();
    }

    private boolean hasPropertiesSidebar() {
        return this.context.target() == RichTextRenderTarget.RP_VIEW;
    }

    private void renderAction(@NotNull HtmlContentBuilder htmlContentBuilder, @NotNull DurationValue total) {
        HtmlTagBuilder a = (HtmlTagBuilder)htmlContentBuilder.tag().a();
        a.append().text("Update time spent in the user story");
        a.attributes().byName("data-action-id", total.toString());
        a.attributes().byName("data-confirm-title", "Update time spent");
        a.attributes().byName("data-confirm-text", "Do you want to update time spent?");
    }

    @Nullable
    private DurationValue appendWorkItemRows(@NotNull HtmlTagBuilder table, @NotNull WorkItem userStory) {
        DurationValue total = null;
        for (LinkedWorkItem linkedWorkItem : userStory.fields().linkedWorkItems().back()) {
            DurationValue sum = null;
            WorkItem workItem = (WorkItem)linkedWorkItem.fields().workItem().getIfCan();
            EnumOption workItemRole = (EnumOption)linkedWorkItem.fields().role().getIfCan();
            if (workItem == null || workItemRole == null || !this.linkRole.id().equals(workItemRole.id())) continue;
            for (WorkRecord workRecord : workItem.fields().workRecords()) {
                DurationValue durationValue = (DurationValue)workRecord.fields().timeSpent().getIfCan();
                if (durationValue == null) continue;
                DurationValue durationValue2 = sum = sum == null ? durationValue : sum.add(durationValue);
            }
            if (total == null) {
                total = sum;
            } else if (sum != null) {
                total = total.add(sum);
            }
            this.appendWorkItemRow(table, workItem, sum);
        }
        return total;
    }

    @NotNull
    private String getStringParameterValue(@NotNull CompositeParameter advanced, @NotNull String parameterId) {
        StringParameter stringParameter = (StringParameter)advanced.get(parameterId);
        String value = stringParameter.value();
        return value == null ? "" : value;
    }

    @Nullable
    private EnumOption getRequiredEnumParameterValue(@NotNull String parameterId) {
        EnumParameter parameter = (EnumParameter)this.context.parameter(parameterId);
        EnumOption value = parameter.singleValue();
        if (value == null) {
            this.setRequiredParameterWarningMessage((RichPageParameter)parameter);
        }
        return value;
    }

    private void setRequiredParameterWarningMessage(@NotNull RichPageParameter parameter) {
        this.warningMessage = "Parameter '" + parameter.label() + "' is required.";
    }

    private void appendWorkItemRow(@NotNull HtmlTagBuilder table, @NotNull WorkItem workItem, @Nullable DurationValue sum) {
        HtmlTagBuilder tr = (HtmlTagBuilder)table.append().tag().tr();
        tr.attributes().className("polarion-rpw-table-content-row");
        if (this.sidebarContainer != null) {
            this.sidebarContainer.openSidebarOnClick(tr).reference((ModelObjectReference)workItem.getReferenceToCurrent());
        }
        HtmlTagBuilder workItemCell = (HtmlTagBuilder)tr.append().tag().td();
        workItemCell.attributes().style(this.rowCellStyle);
        workItem.render().withTitle().htmlTo(workItemCell.append());
        HtmlTagBuilder durationCountCell = (HtmlTagBuilder)tr.append().tag().td();
        durationCountCell.attributes().style(this.rowCellStyle);
        String sumToRender = sum == null ? "0" : sum.normalize().toString();
        durationCountCell.append().text(sumToRender);
    }

    private void appendTotalRow(@NotNull HtmlTagBuilder table, @Nullable DurationValue total) {
        HtmlTagBuilder tr = (HtmlTagBuilder)table.append().tag().tr();
        tr.attributes().className("polarion-rpw-table-content-row");
        HtmlTagBuilder totalLabelCell = (HtmlTagBuilder)tr.append().tag().td();
        totalLabelCell.attributes().style("font-weight:bold;" + this.rowCellStyle);
        totalLabelCell.append().text("Total:");
        String totalToRender = total == null ? "0" : total.normalize().toString();
        HtmlTagBuilder totalCell = (HtmlTagBuilder)tr.append().tag().td();
        totalCell.attributes().style("font-weight:bold;" + this.rowCellStyle);
        totalCell.append().text(totalToRender);
        if (this.hasPermission && total != null && !total.equals(this.userStory.fields().timeSpent().get())) {
            totalCell.append().nbsp().text("(");
            this.renderAction(totalCell.append(), total);
            totalCell.append().text(")");
        }
    }

    private void appendTableHeaderRow(@NotNull HtmlTagBuilder table, @NotNull WorkItem userStory) {
        HtmlTagBuilder tr = (HtmlTagBuilder)table.append().tag().tr();
        tr.attributes().className("polarion-rpw-table-header-row");
        HtmlTagBuilder userStoryCell = (HtmlTagBuilder)tr.append().tag().th();
        userStoryCell.attributes().style(this.headerCellStyle);
        ((WorkItemRenderer)userStory.render().withTitle().withLinks()).htmlTo(userStoryCell.append());
        HtmlTagBuilder timeSpentCell = (HtmlTagBuilder)tr.append().tag().th();
        timeSpentCell.attributes().style(this.headerCellStyle);
        timeSpentCell.append().text("Time Spent:");
    }
}

