/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.widget;

import com.google.gwt.core.shared.GwtIncompatible;
import com.polarion.alm.shared.api.SharedContext;
import com.polarion.alm.shared.api.model.PrototypeEnum;
import com.polarion.alm.shared.api.model.rp.parameter.CompositeParameter;
import com.polarion.alm.shared.api.model.rp.parameter.EnumParameter;
import com.polarion.alm.shared.api.model.rp.parameter.ObjectSelectorParameter;
import com.polarion.alm.shared.api.model.rp.parameter.ParameterFactory;
import com.polarion.alm.shared.api.model.rp.parameter.RichPageParameter;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidget;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidgetActionContext;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidgetContext;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidgetDependenciesContext;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidgetRenderingContext;
import com.polarion.alm.shared.api.model.wi.UpdatableWorkItem;
import com.polarion.alm.shared.api.model.wi.WorkItem;
import com.polarion.alm.shared.api.utils.collections.StrictMap;
import com.polarion.alm.shared.api.utils.collections.StrictMapImpl;
import com.polarion.example.widget.WorkRecordReportWidgetDependenciesProcessor;
import com.polarion.example.widget.WorkRecordReportWidgetRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class WorkRecordReportWidget
extends RichPageWidget {
    private static final String WORK_RECORDS_WIDGET_ICON = "workRecords.png";
    static final String PARAMETER_USER_STORY = "userStory";
    static final String PARAMETER_LINK_ROLE = "linkRole";
    static final String PARAMETER_WI_PROPERTIES_SIDEBAR_FIELDS = "wiPropertiesSidebarFields";
    static final String PARAMETER_TABLE_ROW_CELL_STYLE = "tableRowCellStyle";
    static final String PARAMETER_TABLE_HEADER_CELL_STYLE = "tableHeaderCellStyle";
    static final String PARAMETER_TABLE_STYLE = "tableStyle";

    @NotNull
    public String getIcon(@NotNull RichPageWidgetContext context) {
        return context.resourceUrl(WORK_RECORDS_WIDGET_ICON);
    }

    @NotNull
    @GwtIncompatible
    public InputStream getResourceStream(@NotNull String path) throws IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (stream == null) {
            throw new IOException(String.format("Requested resource '%s' was not found.", path));
        }
        return stream;
    }

    @NotNull
    public String getLabel(@NotNull SharedContext context) {
        return "Work Record Report Widget";
    }

    @NotNull
    public String getDetailsHtml(@NotNull RichPageWidgetContext widgetContext) {
        return "Work Record Report calculates work records from items defined by its parent and link role.";
    }

    @NotNull
    public StrictMap<String, RichPageParameter> getParametersDefinition(@NotNull ParameterFactory factory) {
        StrictMapImpl parameters = new StrictMapImpl();
        parameters.put((Object)PARAMETER_USER_STORY, (Object)((ObjectSelectorParameter.Builder)factory.objectSelector("User Story").allowedPrototypes(PrototypeEnum.WorkItem, new PrototypeEnum[0]).dependencySource(true)).build());
        parameters.put((Object)PARAMETER_LINK_ROLE, (Object)((EnumParameter.Builder)factory.enumeration("Link Role", "workitem-link-role").dependencyTarget(true)).build());
        parameters.put((Object)PARAMETER_WI_PROPERTIES_SIDEBAR_FIELDS, (Object)factory.fields("Work Item Properties Sidebar Fields").fields(Arrays.asList("severity")).build());
        parameters.put((Object)"advanced", (Object)this.buildAdvancedParameter(factory));
        return parameters;
    }

    @NotNull
    private CompositeParameter buildAdvancedParameter(@NotNull ParameterFactory factory) {
        return (CompositeParameter)factory.composite("Advanced").collapsedByDefault(true).add(PARAMETER_TABLE_STYLE, factory.string("Table Style").build()).add(PARAMETER_TABLE_HEADER_CELL_STYLE, factory.string("Table Header Cell Style").value("white-space:nowrap;").build()).add(PARAMETER_TABLE_ROW_CELL_STYLE, factory.string("Table Cell Style").build()).build();
    }

    @NotNull
    public String renderHtml(@NotNull RichPageWidgetRenderingContext context) {
        return new WorkRecordReportWidgetRenderer(context).render();
    }

    public void processParameterDependencies(@NotNull RichPageWidgetDependenciesContext context) {
        new WorkRecordReportWidgetDependenciesProcessor(context).process();
    }

    public void executeAction(@NotNull RichPageWidgetActionContext context) {
        ObjectSelectorParameter parameter = (ObjectSelectorParameter)context.parameter(PARAMETER_USER_STORY);
        WorkItem workItem = (WorkItem)parameter.value();
        if (workItem == null) {
            return;
        }
        UpdatableWorkItem updatableWorkItem = workItem.getUpdatable(context.transaction());
        updatableWorkItem.fields().timeSpent().setDuration(context.actionId());
        updatableWorkItem.save();
        context.refresh(true);
    }
}

