/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.servlet;

import com.polarion.alm.projects.model.IProject;
import com.polarion.alm.tracker.ITrackerService;
import com.polarion.alm.tracker.model.IWorkItem;
import com.polarion.core.util.types.duration.DurationTime;
import com.polarion.platform.core.PlatformContext;
import com.polarion.platform.persistence.model.IPObjectList;
import com.polarion.platform.security.ISecurityService;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CurrentUserWorkloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ITrackerService trackerService = (ITrackerService)PlatformContext.getPlatform().lookupService(ITrackerService.class);
        ISecurityService securityService = (ISecurityService)PlatformContext.getPlatform().lookupService(ISecurityService.class);
        long dayLength = trackerService.getPlanningManager().getOneDayLength();
        String currentUser = securityService.getCurrentUser();
        IPObjectList listOfPrjs = trackerService.getProjectsService().searchProjects("");
        ArrayList<ProjectTimePair> pairs = new ArrayList<ProjectTimePair>();
        for (Object obj : listOfPrjs) {
            IProject prj;
            IPObjectList items;
            if (!(obj instanceof IProject) || (items = trackerService.queryWorkItems(prj = (IProject)obj, "assignee.id:" + currentUser, "remainingEstimate")).size() <= 0) continue;
            ProjectTimePair pair = new ProjectTimePair();
            pair.projectName = prj.getName();
            for (Object obj2 : items) {
                if (!(obj2 instanceof IWorkItem)) continue;
                IWorkItem wi = (IWorkItem)obj2;
                DurationTime t = wi.getRemainingEstimate();
                if (t == null) {
                    t = wi.getInitialEstimate();
                    if (t == null) {
                        pair.time += dayLength;
                        continue;
                    }
                    pair.time += t.getLength();
                    continue;
                }
                pair.time += t.getLength();
            }
            pairs.add(pair);
        }
        req.setAttribute("pairs", pairs);
        req.setAttribute("dayLength", (Object)dayLength);
        this.getServletContext().getRequestDispatcher("/currentUserWorkload.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public static class ProjectTimePair {
        public String projectName;
        public long time = 0L;
    }
}

