/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.job;

import com.polarion.alm.projects.IProjectService;
import com.polarion.alm.projects.model.IProject;
import com.polarion.alm.projects.model.IUser;
import com.polarion.alm.tracker.ITrackerService;
import com.polarion.alm.tracker.model.ITimePoint;
import com.polarion.alm.tracker.model.IWorkItem;
import com.polarion.core.util.types.DateOnly;
import com.polarion.example.job.IOverdueJobUnit;
import com.polarion.platform.announce.Announcement;
import com.polarion.platform.announce.IAnnouncement;
import com.polarion.platform.announce.IAnnouncerService;
import com.polarion.platform.context.IContext;
import com.polarion.platform.core.PlatformContext;
import com.polarion.platform.jobs.GenericJobException;
import com.polarion.platform.jobs.IJobDescriptor;
import com.polarion.platform.jobs.IJobStatus;
import com.polarion.platform.jobs.IJobUnit;
import com.polarion.platform.jobs.IJobUnitFactory;
import com.polarion.platform.jobs.IProgressMonitor;
import com.polarion.platform.jobs.spi.AbstractJobUnit;
import com.polarion.platform.jobs.spi.BasicJobDescriptor;
import com.polarion.platform.jobs.spi.JobParameterPrimitiveType;
import com.polarion.platform.jobs.spi.SimpleJobParameter;
import com.polarion.platform.persistence.model.IPObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OverdueJobUnitFactory
implements IJobUnitFactory {
    public IJobUnit createJobUnit(String name) throws GenericJobException {
        return new OverdueJobUnit(name, this);
    }

    public IJobDescriptor getJobDescriptor(IJobUnit jobUnit) {
        BasicJobDescriptor desc = new BasicJobDescriptor("Overdue job", jobUnit);
        JobParameterPrimitiveType stringType = new JobParameterPrimitiveType("String", String.class);
        JobParameterPrimitiveType integerType = new JobParameterPrimitiveType("Integer", Integer.class);
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "query", "Query for workitems which will be calculated", (IJobDescriptor.IJobParameterType)stringType));
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "sort", "Sort order for query", (IJobDescriptor.IJobParameterType)stringType));
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "notificationSubjectPrefix", "Notification Subject Prefix", (IJobDescriptor.IJobParameterType)stringType));
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "notificationSender", "Notification Sender", (IJobDescriptor.IJobParameterType)stringType));
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "notificationRecipients", "Notification Recipients (author or email addresses with comma delimiter)", (IJobDescriptor.IJobParameterType)stringType));
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "allowedDelay", "Allowed delay in days (used with following formula: currentDate > plannedDate + allowedDelay)", (IJobDescriptor.IJobParameterType)integerType));
        desc.addParameter((IJobDescriptor.IJobParameter)new SimpleJobParameter(desc.getRootParameterGroup(), "planningConstraint", "Defines planning constraint (arguments: timepoint, plannedTo, dueDate; default is timepoint)", (IJobDescriptor.IJobParameterType)stringType));
        return desc;
    }

    public String getName() {
        return "overdue.job";
    }

    private final class OverdueJobUnit
    extends AbstractJobUnit
    implements IOverdueJobUnit {
        private static final String PLANNING_TIMEPOINT = "timepoint";
        private static final String PLANNING_PLANNEDTO = "plannedTo";
        private static final String PLANNING_DUEDATE = "dueDate";
        private static final String NOTIFICATION_ASSIGNEE = "assignee";
        private static final String NOTIFICATION_DEFAULT_SENDER = "polarion@example.com";
        private String query;
        private String sort;
        private String notificationSubjectPrefix;
        private String notificationSender;
        private String notificationRecipients;
        private int allowedDelay;
        private String planningConstraint;

        public OverdueJobUnit(String name, IJobUnitFactory creator) {
            super(name, creator);
            this.allowedDelay = 0;
        }

        @Override
        public void setQuery(String query) {
            this.query = query;
        }

        @Override
        public void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public void setNotificationSubjectPrefix(String notificationSubjectPrefix) {
            this.notificationSubjectPrefix = notificationSubjectPrefix;
        }

        @Override
        public void setNotificationSender(String notificationSender) {
            this.notificationSender = notificationSender;
        }

        @Override
        public void setNotificationRecipients(String notificationRecipients) {
            this.notificationRecipients = notificationRecipients;
        }

        @Override
        public void setAllowedDelay(Integer allowedDelay) {
            this.allowedDelay = allowedDelay;
        }

        public void setPlanningConstraint(String planningConstraint) {
            this.planningConstraint = planningConstraint;
        }

        protected IJobStatus runInternal(IProgressMonitor progress) {
            IProjectService projectService = (IProjectService)PlatformContext.getPlatform().lookupService(IProjectService.class);
            ITrackerService trackerService = (ITrackerService)PlatformContext.getPlatform().lookupService(ITrackerService.class);
            IContext scope = this.getScope();
            progress.beginTask(this.getName(), 0);
            try {
                IProject project = projectService.getProjectForContextId(scope.getId());
                if (project == null) {
                    IJobStatus iJobStatus = this.getStatusFailed("Scope '" + scope.getId() + "' is not project.", null);
                    return iJobStatus;
                }
                this.getLogger().info((Object)("Scope is '" + scope.getId() + "', query is '" + this.query + "', sort is '" + this.sort + "'"));
                IPObjectList workItems = trackerService.queryWorkItems(project, this.query, this.sort);
                this.processWorkItems((Collection<IWorkItem>)workItems);
                IJobStatus iJobStatus = this.getStatusOK(null);
                return iJobStatus;
            }
            finally {
                progress.done();
            }
        }

        private void processWorkItems(Collection<IWorkItem> workItems) {
            LinkedList<IWorkItem> delayedWorkItems = new LinkedList<IWorkItem>();
            for (IWorkItem workItem : workItems) {
                if (!this.checkConstraint(workItem)) continue;
                delayedWorkItems.add(workItem);
            }
            this.processNotifications(delayedWorkItems);
        }

        private boolean checkConstraint(IWorkItem workItem) {
            if (this.planningConstraint == null || PLANNING_TIMEPOINT.equalsIgnoreCase(this.planningConstraint)) {
                return this.checkTimePoint(workItem);
            }
            if (PLANNING_DUEDATE.equalsIgnoreCase(this.planningConstraint)) {
                return this.checkDueDate(workItem);
            }
            if (PLANNING_PLANNEDTO.equalsIgnoreCase(this.planningConstraint)) {
                return this.checkPlannedTo(workItem);
            }
            this.getLogger().info((Object)"Incorrect planning constraint.");
            return false;
        }

        private boolean checkTimePoint(IWorkItem workItem) {
            ITimePoint timepoint = workItem.getTimePoint();
            if (timepoint == null || timepoint.getTime() == null) {
                this.getLogger().info((Object)("WorkItem '" + workItem.getId() + "' has no timepoint defined. Will be skipped."));
                return false;
            }
            Date timepointDate = timepoint.getTime().getDate();
            long diff = this.getTimeDiff(this.getMillisFromDate(timepointDate), System.currentTimeMillis());
            return diff < 0L;
        }

        private boolean checkDueDate(IWorkItem workItem) {
            DateOnly dueDateOnly = workItem.getDueDate();
            if (dueDateOnly == null || dueDateOnly.getDate() == null) {
                this.getLogger().info((Object)("WorkItem '" + workItem.getId() + "' has no dueDate defined. Will be skipped."));
                return false;
            }
            Date dueDate = dueDateOnly.getDate();
            long diff = this.getTimeDiff(this.getMillisFromDate(dueDate), System.currentTimeMillis());
            return diff < 0L;
        }

        private boolean checkPlannedTo(IWorkItem workItem) {
            Date plannedEnd = workItem.getPlannedEnd();
            if (plannedEnd == null) {
                this.getLogger().info((Object)("WorkItem '" + workItem.getId() + "' has no plannedEnd defined. Will be skipped."));
                return false;
            }
            long diff = this.getTimeDiff(this.getMillisFromDate(plannedEnd), System.currentTimeMillis());
            return diff < 0L;
        }

        private long getTimeDiff(long time1, long time2) {
            return time1 + this.getAllowedDelay() - time2;
        }

        private long getAllowedDelay() {
            return this.allowedDelay * 24 * 60 * 60 * 1000;
        }

        private long getMillisFromDate(Date date) {
            return date.getTime();
        }

        private void processNotifications(Collection<IWorkItem> delayedWorkItems) {
            HashMap<String, StringBuilder> emails = new HashMap<String, StringBuilder>();
            for (IWorkItem workItem : delayedWorkItems) {
                Collection<String> recipients = this.getRecipients(workItem);
                StringBuilder content = new StringBuilder();
                StringBuilder contentForLog = new StringBuilder();
                contentForLog.append("WorkItem '").append(workItem.getId()).append("'").append(" in project '").append(workItem.getProject().getName()).append("'").append(" is not resolved after due date.");
                this.getLogger().info((Object)contentForLog.toString());
                content.append("<span>").append((CharSequence)contentForLog).append("</span><br/>\n");
                for (String email : recipients) {
                    StringBuilder contentBuilder = (StringBuilder)emails.get(email);
                    if (contentBuilder == null) {
                        contentBuilder = new StringBuilder();
                        emails.put(email, contentBuilder);
                    }
                    contentBuilder.append((CharSequence)content);
                }
            }
            for (String recipient : emails.keySet()) {
                this.sendNotification(recipient, (StringBuilder)emails.get(recipient));
            }
        }

        private void sendNotification(String recipient, StringBuilder content) {
            IAnnouncerService announcerService = (IAnnouncerService)PlatformContext.getPlatform().lookupService(IAnnouncerService.class);
            content = content != null ? content : new StringBuilder();
            String subjectPrefix = this.notificationSubjectPrefix != null ? this.notificationSubjectPrefix : "";
            subjectPrefix = subjectPrefix.length() > 0 ? String.valueOf(subjectPrefix) + " " : subjectPrefix;
            StringBuilder contentBuilder = new StringBuilder();
            contentBuilder.append("<html><body><b>Overdue WorkItems:</b><br/><br/>\n").append("<p>\n").append(content.toString()).append("</p>\n").append("</body></html>");
            Announcement announcement = new Announcement();
            announcement.setSender(this.notificationSender != null && this.isMailAddress(this.notificationSender) ? this.notificationSender : NOTIFICATION_DEFAULT_SENDER);
            announcement.setReceivers(new String[]{recipient});
            announcement.setContentType("text/html");
            announcement.setSubject(String.valueOf(subjectPrefix) + "Overdue job notification");
            announcement.setContent(contentBuilder.toString());
            try {
                announcerService.sendAnnouncement("smtp", (IAnnouncement)announcement);
            }
            catch (Exception exception) {
                this.getLogger().error((Object)"Could not send notification. Please, check mail settings for Polarion.");
            }
        }

        private Collection<String> getRecipients(IWorkItem workItem) {
            ArrayList<String> rcpts = new ArrayList<String>();
            if (this.notificationRecipients == null || NOTIFICATION_ASSIGNEE.equalsIgnoreCase(this.notificationRecipients)) {
                IPObjectList assignees = workItem.getAssignees();
                for (IUser assignee : assignees) {
                    if (assignee == null || "".equals(assignee.getEmail()) || !this.isMailAddress(assignee.getEmail())) continue;
                    rcpts.add(assignee.getEmail());
                }
            } else {
                String[] recipients;
                String[] stringArray = recipients = this.notificationRecipients.split(",");
                int n = recipients.length;
                int n2 = 0;
                while (n2 < n) {
                    String recipient = stringArray[n2];
                    if ((recipient = recipient.trim()).length() > 0 && this.isMailAddress(recipient)) {
                        rcpts.add(recipient);
                    }
                    ++n2;
                }
            }
            return rcpts;
        }

        private boolean isMailAddress(String address) {
            Pattern emailPattern = Pattern.compile("\\b([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4})\\b");
            Matcher matcher = emailPattern.matcher(address);
            return matcher.find();
        }
    }
}

