/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.importer;

import com.polarion.alm.ws.client.Utils;
import com.polarion.alm.ws.client.WebServiceFactory;
import com.polarion.alm.ws.client.projects.ProjectWebService;
import com.polarion.alm.ws.client.session.SessionWebService;
import com.polarion.alm.ws.client.tracker.TrackerWebService;
import com.polarion.alm.ws.client.types.Text;
import com.polarion.alm.ws.client.types.projects.Project;
import com.polarion.alm.ws.client.types.tracker.Category;
import com.polarion.alm.ws.client.types.tracker.EnumOptionId;
import com.polarion.alm.ws.client.types.tracker.Module;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.rpc.ServiceException;

public class Importer {
    private static final int FIELD_TITLE = 1;
    private static final int FIELD_DESCRIPTION = 2;
    private static final int FIELD_SEVERITY = 3;
    private static final int FIELD_CATEGORY = 4;
    private Properties prop = new Properties();
    private int lineNum;
    private EnumOptionId type;
    LinkedList<String> categories = null;
    private WebServiceFactory factory;
    private SessionWebService sessionService;
    private TrackerWebService trackerService;
    private ProjectWebService projectService;
    private Project project;
    private Module module;
    private HashMap<String, Category> categoriesMap = new HashMap();

    private void setUpPolarionAddress() throws MalformedURLException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.prop.getProperty("polarion_server_address")).append(":").append(this.prop.getProperty("polarion_server_port")).append("/polarion/ws/services/");
        this.factory = new WebServiceFactory(buf.toString());
    }

    private void setUpPolarionWebServices() throws ServiceException {
        this.sessionService = this.factory.getSessionService();
        this.trackerService = this.factory.getTrackerService();
        this.projectService = this.factory.getProjectService();
    }

    public boolean importWIs(String file) throws Exception {
        try {
            this.prop.load(new FileInputStream("settings.properties"));
            this.setUpPolarionAddress();
            this.setUpPolarionWebServices();
            this.sessionService.logIn(this.prop.getProperty("user"), this.prop.getProperty("passwd"));
        }
        catch (MalformedURLException me) {
            this.printError("Provided URL is malformed - protocol unknown.");
            throw me;
        }
        catch (ServiceException se) {
            this.printError("Unreachable web services at Polarion server.");
            throw se;
        }
        catch (RemoteException re) {
            this.printWarning("Log in unsuccessful");
            throw re;
        }
        catch (IOException ioe) {
            this.printError("Properties not loaded.");
            throw ioe;
        }
        try {
            String line;
            Category[] prjCats;
            String projectId = this.prop.getProperty("project_id");
            this.project = this.projectService.getProject(projectId);
            if (this.project.isUnresolvable()) {
                this.printError("Project not found: " + projectId);
                return false;
            }
            String moduleName = this.prop.getProperty("module");
            if (moduleName != null) {
                String moduleLocation = Utils.encodeRelativeLocation((String)moduleName, null);
                this.module = this.trackerService.getModuleByLocation(this.project.getId(), moduleLocation);
                if (this.module == null || this.module.isUnresolvable()) {
                    this.printError("Module not found: " + moduleName);
                    return false;
                }
            }
            if ((prjCats = this.getProjectCategoriesIDs()) != null) {
                for (Category prjCat : prjCats) {
                    this.categoriesMap.put(prjCat.getName(), prjCat);
                }
            }
            this.type = new EnumOptionId(this.prop.getProperty("wi_type", "requirement"));
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            this.sessionService.beginTransaction();
            while ((line = reader.readLine()) != null) {
                this.lineNum = reader.getLineNumber();
                WorkItem wi = this.getWorkItemFromLine(line, this.prop.getProperty("item_delimiter", ";"));
                String wiURI = this.trackerService.createWorkItem(wi);
                Iterator it = this.categories.iterator();
                while (it.hasNext()) {
                    this.trackerService.addCategory(wiURI, (String)it.next());
                }
            }
            this.sessionService.endTransaction(false);
            this.sessionService.endSession();
        }
        catch (RemoteException re) {
            this.printError("Error occured during the execution of a remote method call.");
            throw re;
        }
        catch (IOException ioe) {
            this.printError("Error occured during parsing input file.");
            throw ioe;
        }
        return true;
    }

    private Category[] getProjectCategoriesIDs() throws RemoteException {
        return this.trackerService.getCategories(this.prop.getProperty("project_id"));
    }

    private WorkItem getWorkItemFromLine(String line, String delimiter) {
        String title = "";
        Text desc = new Text("text/plain", "", false);
        String cats = null;
        String severity = "";
        StringTokenizer tok = new StringTokenizer(line, delimiter);
        int i = 1;
        block6: while (tok.hasMoreTokens()) {
            switch (i) {
                case 1: {
                    title = tok.nextToken();
                    ++i;
                    continue block6;
                }
                case 2: {
                    desc.setContent(tok.nextToken());
                    ++i;
                    continue block6;
                }
                case 3: {
                    severity = tok.nextToken();
                    ++i;
                    continue block6;
                }
                case 4: {
                    cats = tok.nextToken();
                    ++i;
                    continue block6;
                }
            }
        }
        WorkItem wi = new WorkItem();
        wi.setTitle(title);
        wi.setDescription(desc);
        wi.setSeverity(new EnumOptionId(severity.toLowerCase()));
        wi.setProject(this.project);
        if (this.module != null) {
            wi.setModuleURI(this.module.getUri());
        }
        wi.setType(this.type);
        this.categories = new LinkedList();
        if (cats != null) {
            this.parseCategories(cats);
        }
        return wi;
    }

    private void parseCategories(String cats) {
        StringTokenizer tok = new StringTokenizer(cats, ",");
        while (tok.hasMoreTokens()) {
            String cat = tok.nextToken();
            if (this.categoriesMap.containsKey(cat)) {
                cat = this.categoriesMap.get(cat).getId();
            }
            this.categories.add(cat);
        }
    }

    public int countParsedLines() {
        return this.lineNum;
    }

    private void printError(String msg) {
        System.err.println("ERROR: " + msg);
    }

    private void printWarning(String msg) {
        System.err.println("WARNING: " + msg);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Importer.printHelp();
            return;
        }
        Importer importer = new Importer();
        try {
            if (importer.importWIs(args[0])) {
                System.out.println("RESULT: operation successful - " + importer.countParsedLines() + " lines were parsed");
            } else {
                System.err.println("RESULT: operation unsuccessful");
            }
        }
        catch (Exception e) {
            System.err.println("RESULT: operation unsuccessful");
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("USAGE: Import <csv_file>\n\n").append("Format of csv file:\n").append("TITLE;ONE_LINE_DESCRIPTION;SEVERITY;CATEGORY");
        System.out.print(buffer.toString());
    }
}

