/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.exporter;

import com.google.gson.GsonBuilder;
import com.polarion.alm.tracker.exporter.AbstractExportCommand;
import com.polarion.alm.tracker.exporter.IExportCommand;
import com.polarion.alm.tracker.exporter.IExportConfiguration;
import com.polarion.alm.tracker.exporter.IPObjectTree;
import com.polarion.alm.tracker.exporter.ITableExportConfiguration;
import com.polarion.alm.tracker.exporter.ITreeExportConfiguration;
import com.polarion.alm.tracker.exporter.TableExportConfiguration;
import com.polarion.alm.tracker.model.IWorkItem;
import com.polarion.example.exporter.CustomExportField;
import com.polarion.example.exporter.CustomExportResult;
import com.polarion.platform.persistence.model.IPObjectList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ExampleExporterCommand
extends AbstractExportCommand {
    @NotNull
    private List<IWorkItem> workItems = new ArrayList<IWorkItem>();

    public void execute() throws Exception {
        this.getWorkItemsFromTableOrTree();
        this.getWorkItemFieldsAndExportThemToJsonFormat();
    }

    private void getWorkItemsFromTableOrTree() {
        Integer maxWorkItems = Optional.ofNullable((Integer)this.config.getParameter("max_workitems_for_export")).orElse(5);
        if (this.config instanceof ITableExportConfiguration) {
            IPObjectList wiList = ((ITableExportConfiguration)this.config).getWorkItems();
            this.overrideFieldConfigurationToCustomFormat((IPObjectList<IWorkItem>)wiList);
            this.workItems = wiList.stream().limit(maxWorkItems.intValue()).collect(Collectors.toList());
        } else if (this.config instanceof ITreeExportConfiguration) {
            ITreeExportConfiguration treeConfig = (ITreeExportConfiguration)this.config;
            this.workItems = treeConfig.getWorkItemTree().getRootNodes().stream().limit(maxWorkItems.intValue()).map(node -> ((IPObjectTree.IPObjectTreeNode)node).getObject()).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("The selected export configuration is not supported.");
        }
    }

    private void getWorkItemFieldsAndExportThemToJsonFormat() throws IOException {
        JSONArray outputJson = new JSONArray();
        this.workItems.forEach(wi -> {
            boolean bl = outputJson.add((Object)this.createJsonStringForWorkItem((IWorkItem)wi));
        });
        this.out.write(new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((Object)outputJson).getBytes());
    }

    @NotNull
    private JSONObject createJsonStringForWorkItem(@NotNull IWorkItem workItem) {
        JSONObject json = new JSONObject();
        this.config.getExportFields().forEach(field -> {
            JSONObject exportFieldProperties = new JSONObject();
            String fieldId = field.getFieldId();
            exportFieldProperties.put((Object)"Field ID", (Object)fieldId);
            Object value = workItem.getValue(fieldId);
            if (value != null) {
                exportFieldProperties.put((Object)"Value", (Object)value.toString());
            }
            exportFieldProperties.put((Object)"Field name", (Object)field.getFieldName());
            exportFieldProperties.put((Object)"Read-only", (Object)field.isReadOnly());
            exportFieldProperties.put((Object)"Removable", (Object)field.isRemovable());
            exportFieldProperties.put((Object)"Column width", (Object)field.getColumnWidth());
            json.put((Object)fieldId, (Object)exportFieldProperties);
        });
        return json;
    }

    @NotNull
    public IExportCommand.IExportResult getResult() {
        Boolean writeGerman = (Boolean)this.config.getParameter("write_result_in_german");
        String resultMessage = writeGerman != null && writeGerman != false ? (String)this.config.getParameter("german_result_message") : (String)this.config.getParameter("english_result_message");
        return new CustomExportResult(IExportCommand.IExportResult.Status.OK, resultMessage);
    }

    private void overrideFieldConfigurationToCustomFormat(@NotNull IPObjectList<IWorkItem> workItems) {
        List<IExportConfiguration.IExportField> fields = this.getExportFields();
        Map<String, Object> parameters = this.getParametersFromHivemodule();
        this.config = new TableExportConfiguration(workItems, ((ITableExportConfiguration)this.config).getQuery(), this.config.getCharset(), fields, this.config.getTemplate(), parameters);
    }

    @NotNull
    private Map<String, Object> getParametersFromHivemodule() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("max_workitems_for_export", this.config.getParameter("max_workitems_for_export"));
        parameters.put("write_result_in_german", this.config.getParameter("write_result_in_german"));
        parameters.put("english_result_message", this.config.getParameter("english_result_message"));
        parameters.put("german_result_message", this.config.getParameter("german_result_message"));
        return parameters;
    }

    @NotNull
    private List<IExportConfiguration.IExportField> getExportFields() {
        ArrayList<IExportConfiguration.IExportField> result = new ArrayList<IExportConfiguration.IExportField>();
        List originalFields = ((ITableExportConfiguration)this.config).getExportFields();
        for (IExportConfiguration.IExportField field : originalFields) {
            boolean isReadOnly = field.isReadOnly();
            if ("status".equals(field.getFieldId()) || "assignee".equals(field.getFieldId())) {
                isReadOnly = false;
            }
            result.add(new CustomExportField(field.getFieldId(), field.getFieldName()).readOnly(isReadOnly));
        }
        return result;
    }
}

