/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.enumerationfactory;

import com.polarion.alm.tracker.ITimePointsManager;
import com.polarion.alm.tracker.ITrackerService;
import com.polarion.alm.tracker.model.ITimePoint;
import com.polarion.platform.persistence.IEnumOption;
import com.polarion.platform.persistence.IEnumeration;
import com.polarion.platform.persistence.model.IPObject;
import com.polarion.platform.persistence.model.IPObjectList;
import com.polarion.platform.persistence.spi.AbstractObjectEnumFactory;
import com.polarion.platform.persistence.spi.AbstractObjectEnumeration;
import com.polarion.platform.persistence.spi.EnumOption;
import com.polarion.subterra.base.data.identification.IContextId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MyTimePointsEnumFactory
extends AbstractObjectEnumFactory {
    private final ITimePointsManager timePointsManager;

    public MyTimePointsEnumFactory(ITrackerService trackerService) {
        this.timePointsManager = trackerService.getTimePointsManager();
    }

    public String getName() {
        return "My Time Points";
    }

    public String getOptionalFieldName() {
        return "Query";
    }

    public IEnumeration getEnumeration(final String enumId, final IContextId contextId) {
        final String query = this.extractValueFromEnumId(enumId);
        return new AbstractObjectEnumeration(enumId){

            public IEnumOption wrapOption(String optionId) {
                LinkedHashMap<String, ITimePoint> timePoints = MyTimePointsEnumFactory.this.getTimePoints(query, contextId);
                ITimePoint timePoint = timePoints.get(optionId);
                if (timePoint == null) {
                    return 1.createPhantomOption((String)enumId, (String)optionId);
                }
                return MyTimePointsEnumFactory.this.wrapTimePoint(enumId, timePoint);
            }

            public List getAvailableOptions(Object controlValue, IEnumOption currentValue) {
                ArrayList<IEnumOption> options = new ArrayList<IEnumOption>();
                LinkedHashMap<String, ITimePoint> timePoints = MyTimePointsEnumFactory.this.getTimePoints(query, contextId);
                boolean currentPresent = false;
                for (ITimePoint timePoint : timePoints.values()) {
                    if (currentValue != null && timePoint.getId().equals(currentValue.getId())) {
                        currentPresent = true;
                    }
                    options.add(MyTimePointsEnumFactory.this.wrapTimePoint(enumId, timePoint));
                }
                if (!currentPresent && currentValue != null) {
                    options.add(currentValue);
                }
                return options;
            }

            @NotNull
            public IEnumOption wrapObject(@NotNull IPObject object) {
                if (object instanceof ITimePoint) {
                    ITimePoint timePoint = (ITimePoint)object;
                    return MyTimePointsEnumFactory.this.wrapTimePoint(enumId, timePoint);
                }
                throw new IllegalArgumentException();
            }
        };
    }

    protected LinkedHashMap<String, ITimePoint> getTimePoints(String query, IContextId contextId) {
        IPObjectList timePoints = this.timePointsManager.getTimePoints(contextId, query, "time", true, false, true);
        LinkedHashMap<String, ITimePoint> timePointsMap = new LinkedHashMap<String, ITimePoint>();
        for (ITimePoint timePoint : timePoints) {
            if (MyTimePointsEnumFactory.isNullOrUnresolvable((IPObject)timePoint)) continue;
            timePointsMap.put(timePoint.getId(), timePoint);
        }
        return timePointsMap;
    }

    protected IEnumOption wrapTimePoint(String enumId, ITimePoint timePoint) {
        return new EnumOption(enumId, timePoint.getId(), String.valueOf(timePoint.getName()) + " (" + timePoint.getTime() + ")", 0, false, MyTimePointsEnumFactory.getExtendedProperties((IPObject)timePoint, null, null));
    }
}

