/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.example.commithook;

import com.polarion.alm.ws.client.WebServiceFactory;
import com.polarion.alm.ws.client.session.SessionWebService;
import com.polarion.alm.ws.client.tracker.TrackerWebService;
import com.polarion.alm.ws.client.types.tracker.EnumOptionId;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;

public class PreCommitHook {
    private final String repos_path;
    private final String txs_number;
    private Properties prop = new Properties();
    private final String dUSER = "admin";
    private final String dPASSWD = "admin";
    private final String dPOLARION_SERVER_ADR = "http://localhost";
    private final String dPOLARION_SERVER_PORT = "81";
    private String commitAuthor;
    private FileOutputStream file;
    private final String dSVNLOOK_DIR = "C:\\Polarion\\bundled\\svn\\bin\\";
    private final String dSVNLOOK_CMD = "svnlook.exe";
    private final String dAPACHE_LOG_FOLDER = "C:\\Polarion\\data\\logs\\apache\\";
    private final String dAPACHE_LOG_FILE_NAME = "commit_audit.log";
    List<String> wis_id = new ArrayList<String>();
    private WebServiceFactory factory;
    private SessionWebService sessionService;
    private TrackerWebService trackerService;
    private static final String ALLOWED_CHARS_EXPR = "[^(){}\\[\\]?!\"':\\,\\s]+";
    private static final Pattern SEARCH_WI_ID_PATTERN = Pattern.compile("[^(){}\\[\\]?!\"':\\,\\s]+-[^(){}\\[\\]?!\"':\\,\\s]+");

    public PreCommitHook(String repo, String txsn, String settingsFileName) throws Exception {
        this.repos_path = repo;
        this.txs_number = txsn;
        this.prop.load(new FileInputStream(settingsFileName));
        this.file = new FileOutputStream(this.prop.getProperty("apache_log_folder", "C:\\Polarion\\data\\logs\\apache\\") + this.prop.getProperty("apache_log_file_name", "commit_audit.log"), true);
        this.loadCommitAuthor();
        this.setUpConnection();
    }

    private void loadCommitAuthor() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.prop.getProperty("svnlook_dir", "C:\\Polarion\\bundled\\svn\\bin\\")).append(this.prop.getProperty("svnlook_cmd", "svnlook.exe")).append(" author ").append(this.repos_path).append(" -t ").append(this.txs_number);
        try {
            Process proc = Runtime.getRuntime().exec(buf.toString());
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            this.commitAuthor = reader.readLine();
            if (this.commitAuthor == null) {
                this.commitAuthor = "Unknown";
            }
            reader.close();
        }
        catch (IOException ioe) {
            this.logError("Retrieving author of commit failed.");
            this.commitAuthor = "Unknown";
        }
    }

    private void setUpConnection() throws MalformedURLException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.prop.getProperty("polarion_server_adr", "http://localhost")).append(":").append(this.prop.getProperty("polarion_server_port", "81")).append("/polarion/ws/services/");
        this.factory = new WebServiceFactory(buf.toString());
    }

    private void setUpSession() throws Exception {
        try {
            this.sessionService = this.factory.getSessionService();
            this.trackerService = this.factory.getTrackerService();
            this.sessionService.logIn(this.prop.getProperty("user", "admin"), this.prop.getProperty("passwd", "admin"));
        }
        catch (ServiceException se) {
            this.logError("WebServices not available");
            throw se;
        }
        catch (RemoteException re) {
            this.logError("Login unsuccessful");
            throw re;
        }
    }

    private List<String> getMessageLines() throws Exception {
        String line;
        StringBuffer buf = new StringBuffer();
        buf.append(this.prop.getProperty("svnlook_dir", "C:\\Polarion\\bundled\\svn\\bin\\")).append(this.prop.getProperty("svnlook_cmd", "svnlook.exe")).append(" log ").append(this.repos_path).append(" -t ").append(this.txs_number);
        Process proc = Runtime.getRuntime().exec(buf.toString());
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        ArrayList<String> l = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            l.add(line);
        }
        reader.close();
        return l;
    }

    private boolean checkMessage(List<String> lines) throws Exception {
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            this.parseLine(it.next().trim());
        }
        if (this.wis_id.isEmpty()) {
            String err = "Commit message has to contain a workItem, to which commit will be linked! Commit interrupted. ";
            this.logError(err);
            return false;
        }
        return true;
    }

    private void parseLine(String line) {
        Matcher matcher = SEARCH_WI_ID_PATTERN.matcher(line);
        while (matcher.find()) {
            this.wis_id.add(matcher.group());
        }
    }

    public boolean check() throws Exception {
        try {
            System.out.println("Setting up Session");
            this.setUpSession();
            List<String> list = this.getMessageLines();
            if (list.isEmpty()) {
                this.logError("Commit message has to contain a workItem, to which commit will be linked! Commit interrupted.");
                boolean bl = false;
                return bl;
            }
            if (list.get(0).startsWith("Polarion commit")) {
                boolean bl = true;
                return bl;
            }
            System.out.println("checking message");
            if (!this.checkMessage(list)) {
                System.err.println("please add a valid work item ID");
                boolean bl = false;
                return bl;
            }
            System.out.println("checking for unresolved links");
            if (!this.checkUnresolvedLinks()) {
                boolean bl = false;
                return bl;
            }
            System.out.println("passed");
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.sessionService != null) {
                this.sessionService.endSession();
            }
            this.file.close();
        }
        return true;
    }

    private String getLinkedWIsDirectQuery() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> iter = this.wis_id.iterator();
        while (iter.hasNext()) {
            String id = iter.next();
            String[] parts = id.split("/");
            String projectId = null;
            String workitemId = null;
            if (parts.length == 2) {
                projectId = parts[0].length() > 0 ? parts[0] : null;
                workitemId = parts[1];
            } else {
                workitemId = parts[0];
            }
            if (projectId != null) {
                sb.append("(project.id:");
                sb.append(projectId);
                sb.append(" AND id:");
                sb.append(workitemId);
                sb.append(")");
            } else {
                sb.append("id:");
                sb.append(workitemId);
            }
            if (!iter.hasNext()) continue;
            sb.append(" OR ");
        }
        String query = sb.toString();
        return query;
    }

    private boolean checkUnresolvedLinks() throws RemoteException {
        String[] fields;
        String query = this.getLinkedWIsDirectQuery();
        WorkItem[] linkedWIs = this.trackerService.queryWorkItems(query, null, fields = new String[]{"resolution", "id"});
        if (linkedWIs == null || linkedWIs.length == 0) {
            String err = "No valid IDs of WorkItem found.";
            this.logError(err);
            return false;
        }
        boolean res = false;
        for (int i = 0; i < linkedWIs.length; ++i) {
            WorkItem wi = linkedWIs[i];
            if (wi.isUnresolvable()) {
                String err = "ID of WorkItem in commit message is not valid";
                this.logError(err);
                res = false;
                break;
            }
            EnumOptionId resId = wi.getResolution();
            if (resId != null) {
                String err = "WI is already resolved and resolution is set.";
                this.logError(err, wi.getId());
                res = false;
                break;
            }
            res = true;
        }
        return res;
    }

    private void logError(String msg) {
        this.log("ERROR: " + msg);
    }

    private void logError(String msg, String WI_id) {
        StringBuffer buf = new StringBuffer();
        buf.append("ERROR: ").append(msg).append(" {workItemID=").append(WI_id).append(", transaction_number=").append(this.txs_number).append(", author=").append(this.commitAuthor).append("}");
        this.log(buf.toString());
    }

    private void log(String msg) {
        System.err.println(msg);
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(Calendar.getInstance().getTime()).append("] - ").append(msg).append("\n");
        try {
            this.file.write(buf.toString().getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.exit(1);
            return;
        }
        try {
            PreCommitHook hook = new PreCommitHook(args[0], args[1], args[2]);
            if (!hook.check()) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

